/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.rewards.ItemStackReward;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.gui.GuiAndroidHud;
import matteroverdrive.gui.GuiDataPad;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementItemPreview;
import matteroverdrive.gui.element.ElementScrollGroup;
import matteroverdrive.gui.element.ElementTextList;
import matteroverdrive.gui.element.IMOListBoxElement;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementListBox;
import matteroverdrive.gui.element.list.ListElementQuest;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.items.DataPad;
import matteroverdrive.network.packet.server.PacketDataPadCommands;
import matteroverdrive.network.packet.server.PacketQuestActions;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;

public class PageActiveQuests
extends ElementBaseGroup
implements IListHandler {
    EnumHand hand;
    ItemStack dataPadStack;
    MOElementListBox quests;
    ElementTextList questInfo;
    ElementBaseGroup questRewards;
    ElementScrollGroup questInfoGroup;

    public PageActiveQuests(GuiDataPad gui, int posX, int posY, int width, int height, String name, OverdriveExtendedProperties extendedProperties) {
        super(gui, posX, posY, width, height);
        this.setName(name);
        this.quests = new MOElementListBox(gui, this, posX + 22, posY + 28, width - 44, 74);
        this.quests.textColor = Reference.COLOR_HOLO.multiplyWithoutAlpha(0.5f).getColor();
        this.quests.selectedTextColor = Reference.COLOR_HOLO.getColor();
        this.questInfo = new ElementTextList(gui, 0, 0, width - 15, Reference.COLOR_HOLO.getColor(), false);
        this.questRewards = new ElementBaseGroup(gui, 8, 8, width - 15, 24);
        this.questRewards.setName("Quest Rewards");
        this.questInfoGroup = new ElementScrollGroup(gui, 22, 120, width - 15, 80);
        this.questInfoGroup.addElement(this.questInfo);
        this.questInfoGroup.addElement(this.questRewards);
        this.questInfoGroup.setScrollerColor(Reference.COLOR_HOLO.getColor());
        this.loadQuests(extendedProperties);
    }

    @Override
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    public void init() {
        super.init();
        this.addElement(this.quests);
        this.addElement(this.questInfoGroup);
    }

    protected void loadQuests(OverdriveExtendedProperties extendedProperties) {
        this.quests.clear();
        for (QuestStack questStack : extendedProperties.getQuestData().getActiveQuests()) {
            this.quests.add(new ListElementQuest(extendedProperties.getPlayer(), questStack, this.quests.getWidth()));
        }
    }

    public void refreshQuests(OverdriveExtendedProperties extendedProperties) {
        this.loadQuests(extendedProperties);
        this.loadSelectedQuestInfo();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        GlStateManager.func_179147_l();
        RenderUtils.applyColorWithAlpha(Reference.COLOR_HOLO, 0.2f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiAndroidHud.top_element_bg);
        RenderUtils.drawPlane(60.0, this.sizeY / 2 - 10, 0.0, 174.0, 11.0);
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
        if (this.dataPadStack.func_77978_p() == null) {
            this.dataPadStack.func_77982_d(new NBTTagCompound());
        }
        ((DataPad)this.dataPadStack.func_77973_b()).setSelectedActiveQuest(this.dataPadStack, selected);
        this.questInfoGroup.setScroll(0);
        this.loadSelectedQuestInfo();
        MatterOverdrive.NETWORK.sendToServer(new PacketDataPadCommands(this.hand, this.dataPadStack));
    }

    private void loadSelectedQuestInfo() {
        this.questInfo.clearLines();
        this.questRewards.clearElements();
        IMOListBoxElement selectedElement = this.quests.getSelectedElement();
        if (selectedElement != null) {
            QuestStack selectedQuest = (QuestStack)selectedElement.getValue();
            if (selectedQuest == null) {
                ((GuiDataPad)this.gui).completeQuestButton.setEnabled(false);
                ((GuiDataPad)this.gui).abandonQuestButton.setEnabled(false);
                return;
            }
            String info = selectedQuest.getInfo((EntityPlayer)Minecraft.func_71410_x().field_71439_g).replace("/n/", "\n");
            if (info != null) {
                List list = this.getFontRenderer().func_78271_c(info, this.sizeX - 32);
                for (String s : list) {
                    this.questInfo.addLine(s);
                }
                this.questInfo.addLine("");
            }
            for (int i = 0; i < selectedQuest.getObjectivesCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g); ++i) {
                List<String> objectiveLines = MatterOverdrive.QUEST_FACTORY.getFormattedQuestObjective((EntityPlayer)Minecraft.func_71410_x().field_71439_g, selectedQuest, i, this.sizeX + 60);
                this.questInfo.addLines(objectiveLines);
            }
            this.questInfo.addLine("");
            this.questInfo.addLine(TextFormatting.GOLD + String.format("Rewards: +%sxp", selectedQuest.getXP((EntityPlayer)Minecraft.func_71410_x().field_71439_g)));
            ArrayList<IQuestReward> rewards = new ArrayList<IQuestReward>();
            selectedQuest.addRewards(rewards, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.questRewards.getElements().clear();
            this.questRewards.setSize(this.questRewards.getWidth(), rewards.size() > 0 ? 20 : 0);
            for (int i = 0; i < rewards.size(); ++i) {
                if (!(rewards.get(i) instanceof ItemStackReward) || !((IQuestReward)rewards.get(i)).isVisible(selectedQuest)) continue;
                ElementItemPreview itemPreview = new ElementItemPreview(this.gui, i * 20, 1, ((ItemStackReward)rewards.get(i)).getItemStack());
                itemPreview.setItemSize(1.0f);
                itemPreview.setRenderOverlay(true);
                itemPreview.setSize(18, 18);
                itemPreview.setDrawTooltip(true);
                itemPreview.setBackground(null);
                this.questRewards.addElement(itemPreview);
            }
            ((GuiDataPad)this.gui).completeQuestButton.setEnabled(QuestStack.canComplete((EntityPlayer)Minecraft.func_71410_x().field_71439_g, selectedQuest));
            ((GuiDataPad)this.gui).abandonQuestButton.setEnabled(true);
        } else {
            ((GuiDataPad)this.gui).completeQuestButton.setEnabled(false);
            ((GuiDataPad)this.gui).abandonQuestButton.setEnabled(false);
        }
    }

    public void setDataPadStack(EnumHand hand, ItemStack dataPadStack) {
        this.dataPadStack = dataPadStack;
        this.hand = hand;
        if (dataPadStack.func_77978_p() != null) {
            this.quests.setSelectedIndex(((DataPad)dataPadStack.func_77973_b()).getActiveSelectedQuest(dataPadStack));
            this.questInfoGroup.setScroll(dataPadStack.func_77978_p().func_74765_d("QuestInfoScroll"));
            this.loadSelectedQuestInfo();
        }
    }

    public void onGuiClose() {
        if (this.dataPadStack.func_77942_o()) {
            this.dataPadStack.func_77978_p().func_74777_a("QuestInfoScroll", (short)this.questInfoGroup.getScroll());
        }
        MatterOverdrive.NETWORK.sendToServer(new PacketDataPadCommands(this.hand, this.dataPadStack));
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String elementName, int mouseButton) {
        super.handleElementButtonClick(element, elementName, mouseButton);
        if (elementName.equalsIgnoreCase("complete_quest")) {
            MatterOverdrive.NETWORK.sendToServer(new PacketQuestActions(1, this.quests.getSelectedIndex(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        } else if (elementName.equalsIgnoreCase("abandon_quest")) {
            MatterOverdrive.NETWORK.sendToServer(new PacketQuestActions(0, this.quests.getSelectedIndex(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        }
    }
}

