/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages.starmap;

import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementQuadrantEntry;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.tile.TileEntityMachineStarMap;

public class PageGalaxy
extends ElementBaseGroup
implements IListHandler {
    private static int scroll;
    private TileEntityMachineStarMap starMap;
    private ElementGroupList quadrantList;

    public PageGalaxy(GuiStarMap gui, int posX, int posY, int width, int height, TileEntityMachineStarMap starMap) {
        super(gui, posX, posY, width, height);
        this.starMap = starMap;
        this.quadrantList = new ElementGroupList(gui, this, 16, 16, 0, 0);
        this.quadrantList.setName("Quadrants");
    }

    private void loadStars() {
        this.quadrantList.init();
        for (Quadrant quadrant : GalaxyClient.getInstance().getTheGalaxy().getQuadrants()) {
            this.quadrantList.addElement(new ElementQuadrantEntry((GuiStarMap)this.gui, this.quadrantList, 192, 32, quadrant));
            if (!this.starMap.getDestination().equals(quadrant)) continue;
            this.quadrantList.setSelectedIndex(this.quadrantList.getElements().size() - 1);
        }
        this.quadrantList.limitScroll();
    }

    @Override
    public void init() {
        super.init();
        this.quadrantList.setSize(this.sizeX, this.sizeY - 100 - 32);
        this.quadrantList.setScroll(scroll);
        this.quadrantList.resetSmoothScroll();
        this.addElement(this.quadrantList);
        this.loadStars();
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTicks) {
        super.update(mouseX, mouseY, partialTicks);
        scroll = this.quadrantList.getScroll();
    }
}

