/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages.starmap;

import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStars;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementStarEntry;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class PageQuadrant
extends ElementBaseGroup
implements IListHandler {
    private static int scroll;
    private TileEntityMachineStarMap starMap;
    private ElementGroupList starList;

    public PageQuadrant(GuiStarMap gui, int posX, int posY, int width, int height, TileEntityMachineStarMap starMap) {
        super(gui, posX, posY, width, height);
        this.starMap = starMap;
        this.starList = new ElementGroupList(gui, this, 16, 16, 0, 0);
        this.starList.setName("Stars");
    }

    private void loadStars() {
        this.starList.init();
        Quadrant quadrant = GalaxyClient.getInstance().getTheGalaxy().getQuadrant(this.starMap.getDestination());
        if (quadrant != null) {
            for (Star star : quadrant.getStars()) {
                Color color = StarMapRendererStars.getStarColor(star, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                this.starList.addElement(new ElementStarEntry((GuiStarMap)this.gui, this.starList, 192, 32, star));
                if (!this.starMap.getDestination().equals(star)) continue;
                this.starList.setSelectedIndex(this.starList.getElements().size() - 1);
            }
        }
        this.starList.limitScroll();
    }

    @Override
    public void init() {
        super.init();
        this.starList.setSize(this.sizeX, this.sizeY - 100 - 32);
        this.starList.setScroll(scroll);
        this.starList.resetSmoothScroll();
        this.addElement(this.starList);
        this.loadStars();
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTicks) {
        super.update(mouseX, mouseY, partialTicks);
        scroll = this.starList.getScroll();
    }
}

