/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import matteroverdrive.Reference;
import matteroverdrive.guide.GuideElementAbstract;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.w3c.dom.Element;

public class GuideElementRecipe
extends GuideElementAbstract {
    private static final ResourceLocation background = new ResourceLocation("matteroverdrive:textures/gui/elements/guide_recipe.png");
    private IRecipe recipe;

    @Override
    public void drawElement(int width, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        if (this.textAlign == 1) {
            GlStateManager.func_179109_b((float)(this.marginLeft + this.width / 2 - 55), (float)this.marginTop, (float)0.0f);
        } else {
            GlStateManager.func_179109_b((float)this.marginLeft, (float)this.marginTop, (float)0.0f);
        }
        this.bindTexture(background);
        RenderUtils.applyColor(Reference.COLOR_MATTER);
        RenderUtils.drawPlane(8.0, 8.0, 0.0, 96.0, 96.0);
        if (this.recipe != null && !this.recipe.func_192400_c().isEmpty()) {
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int index = x + y * 3;
                    if (index >= this.recipe.func_192400_c().size()) continue;
                    Ingredient ingredient = (Ingredient)this.recipe.func_192400_c().get(index);
                    this.renderIngredient(ingredient, x, y);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderIngredient(Ingredient ingredient, int x, int y) {
        ItemStack[] stacks;
        if (ingredient != null && (stacks = ingredient.func_193365_a()).length > 0) {
            int stackIndex = (int)(Minecraft.func_71410_x().field_71441_e.func_72820_D() / 100L % (long)stacks.length);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(10 + x * 33), (float)(9 + y * 33), (float)0.0f);
            GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
            RenderUtils.renderStack(0, 0, stacks[stackIndex]);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected void loadContent(MOGuideEntry entry, Element element, int width, int height) {
        ItemStack output = element.hasAttribute("item") ? this.shortCodeToStack(this.decodeShortcode(element.getAttribute("item"))) : entry.getStackIcons()[0];
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            if (!ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)output)) continue;
            this.recipe = recipe;
            break;
        }
        this.height = 100;
        this.width = 100;
    }
}

