/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide.infograms;

import matteroverdrive.Reference;
import matteroverdrive.guide.GuideElementAbstract;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.Element;

public class InfogramDepth
extends GuideElementAbstract {
    private static final ResourceLocation terrain_background = new ResourceLocation("matteroverdrive:textures/gui/elements/guide_info_depth_terrain.png");
    private static final ResourceLocation terrain_background_stripes = new ResourceLocation("matteroverdrive:textures/gui/elements/guide_info_depth_terrain_stripes.png");
    private static final ResourceLocation ore_lense_background = new ResourceLocation("matteroverdrive:textures/gui/elements/guide_info_depth_ore_lense.png");
    private ItemStack stack;
    private int minDepth = 0;
    private int maxDepth = 64;

    @Override
    public void drawElement(int width, int mouseX, int mouseY) {
        float minPercent = 1.0f - (float)Math.min(this.minDepth, 64) / 64.0f;
        float maxPercent = 1.0f - (float)Math.min(this.maxDepth, 64) / 64.0f;
        if (this.maxDepth >= 0) {
            this.getFontRenderer().func_78276_b(Integer.toString(this.maxDepth) + "-", 8, 8 + (int)(46.0f * maxPercent), Reference.COLOR_HOLO_GREEN.getColor());
        }
        if (this.minDepth > 0) {
            this.getFontRenderer().func_78276_b(Integer.toString(this.minDepth) + "-", 8, 8 + (int)(46.0f * minPercent), Reference.COLOR_HOLO_GREEN.getColor());
        }
        this.bindTexture(terrain_background);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawPlane((double)this.marginLeft + 20.5, this.marginTop + 8, 0.0, 72.5, 53.0);
        RenderUtils.beginStencil();
        RenderUtils.drawStencil(this.marginLeft + 24, this.marginTop + 8 + (int)(53.0f * maxPercent), 93, 8 + (int)(53.0f * minPercent), 1);
        this.bindTexture(terrain_background_stripes);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawPlane(this.marginLeft + 24, this.marginTop + 8, 0.0, 69.0, 53.0);
        RenderUtils.endStencil();
        this.bindTexture(ore_lense_background);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawPlane(this.marginLeft + 69, this.marginTop + 16, 0.0, 84.0, 41.0);
        if (!this.stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.marginLeft + 123), (float)(this.marginTop + 21), (float)0.0f);
            GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
            RenderUtils.renderStack(0, 0, this.stack);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected void loadContent(MOGuideEntry entry, Element element, int width, int height) {
        if (element.hasAttribute("min")) {
            this.minDepth = Integer.parseInt(element.getAttribute("min"));
        }
        if (element.hasAttribute("max")) {
            this.maxDepth = Integer.parseInt(element.getAttribute("max"));
        }
        if (element.hasAttribute("item")) {
            this.stack = this.shortCodeToStack(this.decodeShortcode(element.getAttribute("item")));
        } else if (entry.getStackIcons().length > 0) {
            this.stack = entry.getStackIcons()[0];
        }
        this.width = 100;
        this.height = 69;
    }
}

