/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import java.util.Collection;
import java.util.HashMap;
import matteroverdrive.api.android.IAndroidStatRegistry;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.api.events.MOEventRegisterAndroidStat;
import matteroverdrive.client.render.HoloIcons;
import matteroverdrive.util.MOLog;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class AndroidStatRegistry
implements IAndroidStatRegistry {
    private final HashMap<String, IBioticStat> stats = new HashMap();

    @Override
    public boolean registerStat(IBioticStat stat) {
        if (this.stats.containsKey(stat.getUnlocalizedName())) {
            MOLog.warn("Stat with the name '%s' is already present!", stat.getUnlocalizedName());
        } else if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventRegisterAndroidStat(stat))) {
            this.stats.put(stat.getUnlocalizedName(), stat);
            return true;
        }
        return false;
    }

    @Override
    public IBioticStat getStat(String name) {
        return this.stats.get(name);
    }

    @Override
    public boolean hasStat(String name) {
        return this.stats.containsKey(name);
    }

    @Override
    public IBioticStat unregisterStat(String statName) {
        return this.stats.remove(statName);
    }

    public void registerIcons(TextureMap textureMap, HoloIcons holoIcons) {
        for (IBioticStat stat : this.stats.values()) {
            stat.registerIcons(textureMap, holoIcons);
        }
    }

    public Collection<IBioticStat> getStats() {
        return this.stats.values();
    }
}

