/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.network.IMatterNetworkHandler;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.MatterNetworkTickHandler;
import matteroverdrive.handler.PlayerEventHandler;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.IMOTickable;
import matteroverdrive.util.MOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class TickHandler {
    private final MatterNetworkTickHandler matterNetworkTickHandler;
    private final PlayerEventHandler playerEventHandler;
    private boolean worldStartFired = false;
    private long lastTickTime;
    private int lastTickLength;

    public TickHandler(ConfigurationHandler configurationHandler, PlayerEventHandler playerEventHandler) {
        this.playerEventHandler = playerEventHandler;
        this.matterNetworkTickHandler = new MatterNetworkTickHandler();
        configurationHandler.subscribe(this.matterNetworkTickHandler);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (ClientProxy.instance().getClientWeaponHandler() != null) {
            ClientProxy.instance().getClientWeaponHandler().onClientTick(event);
        }
        if (!Minecraft.func_71410_x().func_147113_T() && event.phase.equals((Object)TickEvent.Phase.START)) {
            ClientProxy.questHud.onTick();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        this.playerEventHandler.onServerTick(event);
        this.lastTickLength = (int)(System.nanoTime() - this.lastTickTime);
        this.lastTickTime = System.nanoTime();
    }

    public void onServerStart(FMLServerStartedEvent event) {
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ClientProxy.instance().getClientWeaponHandler().onTick(event);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!this.worldStartFired) {
            this.onWorldStart(event.side, event.world);
            this.worldStartFired = true;
        }
        if (event.side.isServer()) {
            FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b.func_76320_a("MO WorldTick Tiles");
            this.matterNetworkTickHandler.onWorldTickPre(event.phase, event.world);
            int tileEntityListSize = event.world.field_147482_g.size();
            for (int i = 0; i < tileEntityListSize; ++i) {
                try {
                    TileEntity tileEntity = (TileEntity)event.world.field_147482_g.get(i);
                    if (!(tileEntity instanceof IMOTickable)) continue;
                    if (tileEntity instanceof IMatterNetworkHandler) {
                        this.matterNetworkTickHandler.updateHandler((IMatterNetworkHandler)tileEntity, event.phase, event.world);
                        continue;
                    }
                    ((IMOTickable)tileEntity).onServerTick(event.phase, event.world);
                    continue;
                }
                catch (Throwable e) {
                    MOLog.log(Level.ERROR, e, "There was an Error while updating Matter Overdrive Tile Entities.", new Object[0]);
                    return;
                }
            }
            FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b.func_76319_b();
            this.matterNetworkTickHandler.onWorldTickPost(event.phase, event.world);
        }
        MatterOverdrive.MO_WORLD.onWorldTick(event);
    }

    public void onWorldStart(Side side, World world) {
    }

    public int getLastTickLength() {
        return this.lastTickLength;
    }
}

