/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.api.exceptions.MOQuestParseException;
import matteroverdrive.api.quest.IQuestLogic;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.Quest;
import matteroverdrive.data.quest.GenericMultiQuest;
import matteroverdrive.data.quest.GenericQuest;
import matteroverdrive.data.quest.WeightedRandomQuest;
import matteroverdrive.data.quest.logic.QuestLogicBlockInteract;
import matteroverdrive.data.quest.logic.QuestLogicCollectItem;
import matteroverdrive.data.quest.logic.QuestLogicConversation;
import matteroverdrive.data.quest.logic.QuestLogicCraft;
import matteroverdrive.data.quest.logic.QuestLogicItemInteract;
import matteroverdrive.data.quest.logic.QuestLogicKillCreature;
import matteroverdrive.data.quest.logic.QuestLogicMine;
import matteroverdrive.data.quest.logic.QuestLogicPlaceBlock;
import matteroverdrive.data.quest.logic.QuestLogicScanBlock;
import matteroverdrive.data.quest.logic.QuestLogicSingleEvent;
import matteroverdrive.data.quest.logic.QuestLogicTeleport;
import matteroverdrive.data.quest.rewards.EntityReward;
import matteroverdrive.data.quest.rewards.ItemStackReward;
import matteroverdrive.data.quest.rewards.QuestStackReward;
import matteroverdrive.data.quest.rewards.SoundReward;
import matteroverdrive.handler.quest.Quests;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.util.MOJsonHelper;
import matteroverdrive.util.MOLog;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class QuestAssembler {
    private static final ResourceLocation questsLocation = new ResourceLocation("matteroverdrive:quests/quests.json");
    private static final String customQuestsLocation = "custom_quests.json";
    private Map<String, Class<? extends IQuestLogic>> questLogicClassMap = new HashMap<String, Class<? extends IQuestLogic>>();
    private Map<String, Class<? extends IQuestReward>> questRewardClassMap = new HashMap<String, Class<? extends IQuestReward>>();
    private String currentQuestName;

    public QuestAssembler() {
        this.loadBasicQuestLogics();
        this.loadBasicQuestRewards();
    }

    protected void loadBasicQuestLogics() {
        this.addQuestLogicClass("kill_creature", QuestLogicKillCreature.class);
        this.addQuestLogicClass("collect_item", QuestLogicCollectItem.class);
        this.addQuestLogicClass("craft", QuestLogicCraft.class);
        this.addQuestLogicClass("mine", QuestLogicMine.class);
        this.addQuestLogicClass("event_trigger", QuestLogicSingleEvent.class);
        this.addQuestLogicClass("teleport", QuestLogicTeleport.class);
        this.addQuestLogicClass("place", QuestLogicPlaceBlock.class);
        this.addQuestLogicClass("scan", QuestLogicScanBlock.class);
        this.addQuestLogicClass("interact_block", QuestLogicBlockInteract.class);
        this.addQuestLogicClass("interact_item", QuestLogicItemInteract.class);
        this.addQuestLogicClass("conversation", QuestLogicConversation.class);
    }

    protected void loadBasicQuestRewards() {
        this.addQuestRewardClass("item", ItemStackReward.class);
        this.addQuestRewardClass("quest", QuestStackReward.class);
        this.addQuestRewardClass("entity", EntityReward.class);
        this.addQuestRewardClass("sound", SoundReward.class);
    }

    public void loadQuests(Quests quests) {
        String path = "/assets/" + questsLocation.func_110624_b() + "/" + questsLocation.func_110623_a();
        InputStream inputStream = QuestAssembler.class.getResourceAsStream(path);
        this.loadQuests(inputStream, quests);
    }

    public void loadCustomQuests(Quests quests) {
        File file = new File(customQuestsLocation);
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                this.loadQuests(inputStream, quests);
            }
            catch (FileNotFoundException e) {
                MOLog.log(Level.ERROR, e, "Cannot find Custom Quests file at %s.", file.getAbsolutePath());
            }
        } else {
            MOLog.info("No Custom Quests file found at %s", file.getAbsolutePath());
        }
    }

    private void loadQuests(InputStream inputStream, Quests quests) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        JsonParser jsonParser = new JsonParser();
        JsonObject mainQuestsObject = jsonParser.parse((Reader)inputStreamReader).getAsJsonObject();
        mainQuestsObject.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonObject()).forEach(entry -> {
            this.currentQuestName = (String)entry.getKey();
            GenericQuest quest = this.parseQuest((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject());
            if (quest != null) {
                quests.registerQuest(quest.getName(), quest);
                int contractWeight = MOJsonHelper.getInt(((JsonElement)entry.getValue()).getAsJsonObject(), "contract_market", 0);
                if (contractWeight > 0) {
                    MatterOverdriveQuests.contractGeneration.add(new WeightedRandomQuest(quest, contractWeight));
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GenericQuest parseQuest(String title, JsonObject object) {
        Quest genericQuest = null;
        MOJsonHelper.setCurrentParentObject(title);
        String type = MOJsonHelper.getString(object, "type");
        if (type.equalsIgnoreCase("generic")) {
            if (!object.has("logic") || !object.get("logic").isJsonObject()) throw new MOQuestParseException("Missing Quest Logic for Quest: '%s'", title);
            IQuestLogic questLogic = this.parseLogic(object.get("logic").getAsJsonObject());
            if (questLogic == null) throw new MOQuestParseException("There was a problem while parsing Quest logic for: '%s'", title);
            genericQuest = new GenericQuest(title, object, questLogic);
        } else if (type.equalsIgnoreCase("generic_multi")) {
            if (!object.has("logic") || !object.get("logic").isJsonArray()) throw new MOQuestParseException("Missing Quest Logic for Quest: '%s'", title);
            JsonArray logicElements = object.getAsJsonArray("logic");
            IQuestLogic[] logics = new IQuestLogic[logicElements.size()];
            for (int i = 0; i < logicElements.size(); ++i) {
                IQuestLogic questLogic = this.parseLogic(logicElements.get(i).getAsJsonObject());
                if (questLogic == null) {
                    throw new MOQuestParseException("There was a problem parsing one of the Quest logics in: '%s'", title);
                }
                logics[i] = questLogic;
            }
            genericQuest = new GenericMultiQuest(title, object, logics);
        }
        if (genericQuest == null || !object.has("rewards") || !object.get("rewards").isJsonArray()) return genericQuest;
        genericQuest.addQuestRewards(this.parseRewards(object.get("rewards").getAsJsonArray()));
        return genericQuest;
    }

    private IQuestLogic parseLogic(JsonObject object) {
        String type = MOJsonHelper.getString(object, "type");
        Class<? extends IQuestLogic> logicClass = this.questLogicClassMap.get(type);
        if (logicClass != null) {
            try {
                IQuestLogic logic = logicClass.newInstance();
                logic.loadFromJson(object);
                return logic;
            }
            catch (InstantiationException e) {
                MOLog.log(Level.ERROR, e, "Could not create Quest Logic with default constructor", new Object[0]);
            }
            catch (IllegalAccessException e) {
                MOLog.log(Level.ERROR, e, "Could not create Quest Logic with private constructor", new Object[0]);
            }
        }
        MOLog.log(Level.ERROR, "Could not find quest logic of type: %s", type);
        return null;
    }

    public List<IQuestReward> parseRewards(JsonArray rewards) {
        ArrayList<IQuestReward> rewardList = new ArrayList<IQuestReward>();
        for (JsonElement element : rewards) {
            String type;
            if (!element.isJsonObject()) continue;
            try {
                type = element.getAsJsonObject().get("type").getAsString();
            }
            catch (Exception e) {
                throw new MOQuestParseException(String.format("Could not parse reward type in quest: '%s'", this.currentQuestName), e);
            }
            Class<? extends IQuestReward> rewardClass = this.questRewardClassMap.get(type);
            if (rewardClass != null) {
                try {
                    IQuestReward reward = rewardClass.newInstance();
                    reward.loadFromJson(element.getAsJsonObject());
                    rewardList.add(reward);
                }
                catch (InstantiationException e) {
                    MOLog.log(Level.ERROR, e, "Could not instantiate Quest Reward", new Object[0]);
                }
                catch (IllegalAccessException e) {
                    MOLog.log(Level.ERROR, e, "Could not call private constructor on Quest Reward", new Object[0]);
                }
                continue;
            }
            throw new MOQuestParseException(String.format("No such reward type as: '%s' in quest: '%s'", type, this.currentQuestName), new Object[0]);
        }
        return rewardList;
    }

    public void addQuestLogicClass(String name, Class<? extends IQuestLogic> questLogicClass) {
        this.questLogicClassMap.put(name, questLogicClass);
    }

    public void addQuestRewardClass(String name, Class<? extends IQuestReward> questRewardClass) {
        this.questRewardClassMap.put(name, questRewardClass);
    }
}

