/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.EntityDrone;
import matteroverdrive.entity.EntityFailedChicken;
import matteroverdrive.entity.EntityFailedCow;
import matteroverdrive.entity.EntityFailedPig;
import matteroverdrive.entity.EntityFailedSheep;
import matteroverdrive.entity.EntityVillagerMadScientist;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityMutantScientist;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.entity.monster.EntityRogueAndroid;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.village.VillageCreatationMadScientist;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MatterOverdriveEntities {
    public static final int ENTITY_STARTING_ID = 171;
    public static EntityRogueAndroid rogueandroid;
    public static VillagerRegistry.VillagerProfession MAD_SCIENTIST_PROFESSION;
    public static VillagerRegistry.VillagerCareer MAD_SCIENTIST_CAREER;
    public static boolean enableVillager;

    public static void init(FMLPreInitializationEvent event, ConfigurationHandler configurationHandler) {
        rogueandroid = new EntityRogueAndroid();
        configurationHandler.subscribe(rogueandroid);
    }

    public static void register(FMLPreInitializationEvent event) {
        MatterOverdrive.CONFIG_HANDLER.config.load();
        int id = 0;
        MatterOverdriveEntities.addEntity(EntityFailedPig.class, "failed_pig", 15771042, 0x33CC33, id++);
        MatterOverdriveEntities.addEntity(EntityFailedCow.class, "failed_cow", 4470310, 0x33CC33, id++);
        MatterOverdriveEntities.addEntity(EntityFailedChicken.class, "failed_chicken", 0xA1A1A1, 0x33CC33, id++);
        MatterOverdriveEntities.addEntity(EntityFailedSheep.class, "failed_sheep", 0xE7E7E7, 0x33CC33, id++);
        if (MatterOverdriveEntities.addEntity(EntityVillagerMadScientist.class, "mad_scientist", 0xFFFFFF, 0, id++)) {
            VillageCreatationMadScientist creatationMadScientist = new VillageCreatationMadScientist();
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)creatationMadScientist);
        }
        MatterOverdriveEntities.addEntity(EntityMutantScientist.class, "mutant_scientist", 0xFFFFFF, 65280, id++);
        if (MatterOverdriveEntities.addEntity(EntityMeleeRougeAndroidMob.class, "rogue_android", 1048575, 0, id++)) {
            EntityRogueAndroid.addAsBiomeGen(EntityMeleeRougeAndroidMob.class);
        }
        if (MatterOverdriveEntities.addEntity(EntityRangedRogueAndroidMob.class, "ranged_rogue_android", 1048575, 0, id++)) {
            EntityRogueAndroid.addAsBiomeGen(EntityRangedRogueAndroidMob.class);
        }
        MatterOverdriveEntities.addEntity(EntityDrone.class, "drone", 4084052, 12231108, id++);
        MatterOverdrive.CONFIG_HANDLER.save();
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        MAD_SCIENTIST_PROFESSION = new VillagerRegistry.VillagerProfession("matteroverdrive:mad_scientist", "matteroverdrive:textures/entities/mad_scientist.png", "matteroverdrive:textures/entities/hulking_scinetist.png"){

            public VillagerRegistry.VillagerCareer getCareer(int id) {
                return MAD_SCIENTIST_CAREER;
            }
        };
        MAD_SCIENTIST_CAREER = new VillagerRegistry.VillagerCareer(MAD_SCIENTIST_PROFESSION, "matteroverdrive.mad_scientist");
        event.getRegistry().register((IForgeRegistryEntry)MAD_SCIENTIST_PROFESSION);
    }

    public static boolean addEntity(Class<? extends Entity> enityClass, String name, int mainColor, int spotsColor, int id) {
        boolean enabled = MatterOverdrive.CONFIG_HANDLER.config.getBoolean("enable", String.format("%s.%s", "entities", name), true, "");
        if (enabled) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("matteroverdrive", name), enityClass, (String)name, (int)id, (Object)MatterOverdrive.INSTANCE, (int)64, (int)1, (boolean)true, (int)mainColor, (int)spotsColor);
        }
        return enabled;
    }

    static {
        enableVillager = false;
    }
}

