/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.android;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.IBionicPart;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BionicPart
extends MOBaseItem
implements IBionicPart {
    public BionicPart(String name) {
        super(name);
        this.func_77637_a(MatterOverdrive.TAB_OVERDRIVE_ANDROID_PARTS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        super.addDetails(itemstack, player, worldIn, infos);
        Multimap<String, AttributeModifier> multimap = this.getModifiers(MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player), itemstack);
        if (multimap != null) {
            multimap.values().forEach(modifier -> {
                switch (modifier.func_111169_c()) {
                    case 0: {
                        infos.add(TextFormatting.GREEN + String.format("%s: +%s", modifier.func_111166_b(), modifier.func_111164_d()));
                        break;
                    }
                    case 1: {
                        infos.add(TextFormatting.GREEN + String.format("%s: %s", modifier.func_111166_b(), (modifier.func_111164_d() >= 0.0 ? "+" : "") + DecimalFormat.getPercentInstance().format(modifier.func_111164_d())));
                        break;
                    }
                    default: {
                        infos.add(TextFormatting.GREEN + String.format("%s: %s", modifier.func_111166_b(), DecimalFormat.getPercentInstance().format(modifier.func_111164_d() + 1.0)));
                    }
                }
            });
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getModifiers(AndroidPlayer player, ItemStack itemStack) {
        HashMultimap multimap = HashMultimap.create();
        this.loadCustomAttributes(itemStack, (Multimap<String, AttributeModifier>)multimap);
        return multimap;
    }

    private void loadCustomAttributes(ItemStack itemStack, Multimap<String, AttributeModifier> multimap) {
        if (itemStack.func_77978_p() != null) {
            NBTTagList attributeList = itemStack.func_77978_p().func_150295_c("CustomAttributes", 10);
            for (int i = 0; i < attributeList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = attributeList.func_150305_b(i);
                String attributeName = tagCompound.func_74779_i("Name");
                double amount = tagCompound.func_74769_h("Amount");
                byte operation = tagCompound.func_74771_c("Operation");
                multimap.put((Object)attributeName, (Object)new AttributeModifier(UUID.fromString(tagCompound.func_74779_i("UUID")), MOStringHelper.translateToLocal("attribute.name." + attributeName, new Object[0]), amount, (int)operation));
            }
        }
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return true;
    }
}

