/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.weapon.MOEventEnergyWeapon;
import matteroverdrive.api.inventory.IEnergyPack;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.IWeaponScope;
import matteroverdrive.api.weapon.IWeaponStat;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.api.weapon.WeaponStats;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.init.MatterOverdriveEnchantments;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.includes.EnergyContainer;
import matteroverdrive.items.includes.MOItemEnergyContainer;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.network.packet.server.PacketReloadEnergyWeapon;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.EntityDamageSourcePhaser;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EnergyWeapon
extends MOItemEnergyContainer
implements IWeapon {
    public static final String CUSTOM_DAMAGE_TAG = "CustomDamage";
    public static final String CUSTOM_ACCURACY_TAG = "CustomAccuracy";
    public static final String CUSTOM_RANGE_TAG = "CustomRange";
    public static final String CUSTOM_SPEED_TAG = "CustomSpeed";
    public static final String CUSTOM_DAMAGE_MULTIPLY_TAG = "CustomDamageMultiply";
    public static final String CUSTOM_ACCURACY_MULTIPLY_TAG = "CustomAccuracyMultiply";
    public static final String CUSTOM_RANGE_MULTIPLY_TAG = "CustomRangeMultiply";
    public static final String CUSTOM_SPEED_MULTIPLY_TAG = "CustomSpeedMultiply";
    private final int defaultRange;
    private final DecimalFormat damageFormater = new DecimalFormat("#.##");
    protected boolean leftClickFire;

    public EnergyWeapon(String name, int defaultRange) {
        super(name);
        this.defaultRange = defaultRange;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        return WeaponHelper.getColor(stack);
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    public int getItemStackLimit(ItemStack item) {
        return 1;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean isHolding) {
        if (!world.field_72995_K) {
            this.manageCooling(itemStack);
        } else if (entity instanceof EntityPlayer && entity == Minecraft.func_71410_x().field_71439_g && ((EntityPlayer)entity).func_184614_ca() == itemStack && Minecraft.func_71410_x().field_71462_r == null) {
            this.onShooterClientUpdate(itemStack, world, (EntityPlayer)entity, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack weapon, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        super.addDetails(weapon, player, worldIn, infos);
        String energyInfo = TextFormatting.DARK_RED + "Power Use: " + MOEnergyHelper.formatEnergy(null, (long)(this.getEnergyUse(weapon) * 20)) + "/s";
        float energyMultiply = (float)this.getEnergyUse(weapon) / (float)this.getBaseEnergyUse(weapon);
        if (energyMultiply != 1.0f) {
            energyInfo = energyInfo + " (" + DecimalFormat.getPercentInstance().format(energyMultiply) + ")";
        }
        infos.add(energyInfo);
        infos.add("");
        infos.add(this.addStatWithMultiplyInfo("Damage", this.damageFormater.format(this.getWeaponScaledDamage(weapon, (EntityLivingBase)player)), this.getWeaponScaledDamage(weapon, (EntityLivingBase)player) / this.getWeaponBaseDamage(weapon), ""));
        infos.add(this.addStatWithMultiplyInfo("DPS", this.damageFormater.format(this.getWeaponScaledDamage(weapon, (EntityLivingBase)player) / (float)this.getShootCooldown(weapon) * 20.0f), 1.0, ""));
        infos.add(this.addStatWithMultiplyInfo("Speed", (int)(20.0 / (double)this.getShootCooldown(weapon) * 60.0), (double)this.getBaseShootCooldown(weapon) / (double)this.getShootCooldown(weapon), " s/m"));
        infos.add(this.addStatWithMultiplyInfo("Range", this.getRange(weapon), (double)this.getRange(weapon) / (double)this.defaultRange, "b"));
        infos.add(this.addStatWithMultiplyInfo("Accuracy", "", 1.0f / (this.modifyStatFromModules(WeaponStats.ACCURACY, weapon, 1.0f) * this.getCustomFloatStat(weapon, CUSTOM_ACCURACY_MULTIPLY_TAG, 1.0f)), ""));
        StringBuilder heatInfo = new StringBuilder(TextFormatting.DARK_RED + "Heat: ");
        double heatPercent = this.getHeat(weapon) / this.getMaxHeat(weapon);
        int i = 0;
        while ((double)i < 32.0 * heatPercent) {
            heatInfo.append("|");
            ++i;
        }
        infos.add(heatInfo.toString());
        infos.add("");
        this.addCustomDetails(weapon, player, infos);
        this.AddModuleDetails(weapon, infos);
    }

    public boolean isEntitySpectator(EntityLivingBase entity) {
        return entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v();
    }

    private String addStatWithMultiplyInfo(String statName, Object value, double multiply, String units) {
        String info = String.format("%s: %s%s", statName, TextFormatting.DARK_AQUA, value);
        if (!units.isEmpty()) {
            info = info + " " + units;
        }
        if (multiply != 1.0) {
            info = multiply > 1.0 ? info + TextFormatting.DARK_GREEN : info + TextFormatting.DARK_RED;
            info = info + String.format(" (%s) %s", DecimalFormat.getPercentInstance().format(multiply), TextFormatting.RESET);
        }
        return info;
    }

    private void AddModuleDetails(ItemStack weapon, List infos) {
        ItemStack module = WeaponHelper.getModuleAtSlot(2, weapon);
        if (!module.func_190926_b()) {
            // empty if block
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void manageClientServerTicks(World world) {
        ClientProxy.instance().getClientWeaponHandler().sendWeaponTickToServer(world, null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void sendShootTickToServer(World world, WeaponShot weaponShot, Vec3d dir, Vec3d pos) {
        PacketFirePlasmaShot packetFirePlasmaShot = new PacketFirePlasmaShot(Minecraft.func_71410_x().field_71439_g.func_145782_y(), pos, dir, weaponShot);
        ClientProxy.instance().getClientWeaponHandler().sendWeaponTickToServer(world, packetFirePlasmaShot);
    }

    @SideOnly(value=Side.CLIENT)
    public void addShootDelay(ItemStack weaponStack) {
        ClientProxy.instance().getClientWeaponHandler().addShootDelay(this, weaponStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasShootDelayPassed() {
        return ClientProxy.instance().getClientWeaponHandler().shootDelayPassed(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack weapon, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (sendServerTick) {
            this.manageClientServerTicks(world);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onLeftClick(ItemStack weapon, EntityPlayer entityPlayer) {
        return this.leftClickFire;
    }

    public void chargeFromEnergyPack(ItemStack weapon, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyPack) || stack.func_190916_E() <= 0) continue;
                stack.func_190918_g(1);
                IEnergyStorage container = EnergyWeapon.getStorage(weapon);
                if (container instanceof EnergyContainer) {
                    ((EnergyContainer)container).setEnergy(container.getEnergyStored() + ((IEnergyPack)stack.func_77973_b()).getEnergyAmount(stack));
                }
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), MatterOverdriveSounds.weaponsReload, SoundCategory.PLAYERS, 0.7f + field_77697_d.nextFloat() * 0.2f, 0.9f + field_77697_d.nextFloat() * 0.2f);
                if (stack.func_190916_E() <= 0) {
                    player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                }
                return;
            }
        } else {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyPack) || stack.func_190916_E() <= 0) continue;
                ClientProxy.instance().getClientWeaponHandler().addReloadDelay(this, 40);
                MatterOverdrive.NETWORK.sendToServer(new PacketReloadEnergyWeapon());
                return;
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) || slotChanged;
    }

    protected void manageOverheat(ItemStack itemStack, World world, EntityLivingBase shooter) {
        if (this.getHeat(itemStack) >= this.getMaxHeat(itemStack) && !MinecraftForge.EVENT_BUS.post((Event)new MOEventEnergyWeapon.Overheat(itemStack, shooter))) {
            this.setOverheated(itemStack, true);
            world.func_184148_a(null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, MatterOverdriveSounds.weaponsOverheat, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_184148_a(null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, MatterOverdriveSounds.weaponsOverheatAlarm, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == MatterOverdriveEnchantments.overclock;
    }

    protected void manageCooling(ItemStack itemStack) {
        float heat = this.getHeat(itemStack);
        if (heat > 0.0f) {
            float easing = MOEasing.Quart.easeOut(heat / this.getMaxHeat(itemStack), 0.0f, 4.0f, 1.0f);
            float newHeat = heat - easing;
            if (newHeat < 0.001f) {
                newHeat = 0.0f;
            }
            this.setHeat(itemStack, Math.max(0.0f, newHeat));
        }
        if (this.isOverheated(itemStack) && this.getHeat(itemStack) < 2.0f) {
            this.setOverheated(itemStack, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void addCustomDetails(ItemStack var1, EntityPlayer var2, List var3);

    protected abstract int getBaseEnergyUse(ItemStack var1);

    protected abstract int getBaseMaxHeat(ItemStack var1);

    public abstract float getWeaponBaseDamage(ItemStack var1);

    public abstract float getWeaponBaseAccuracy(ItemStack var1, boolean var2);

    public abstract boolean canFire(ItemStack var1, World var2, EntityLivingBase var3);

    public abstract float getShotSpeed(ItemStack var1, EntityLivingBase var2);

    public abstract int getBaseShootCooldown(ItemStack var1);

    public abstract float getBaseZoom(ItemStack var1, EntityLivingBase var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void onClientShot(ItemStack var1, EntityLivingBase var2, Vec3d var3, Vec3d var4, WeaponShot var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void onProjectileHit(RayTraceResult var1, ItemStack var2, World var3, float var4);

    public PlasmaBolt getDefaultProjectile(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        PlasmaBolt fire = new PlasmaBolt(shooter.field_70170_p, shooter, position, dir, shot, this.getShotSpeed(weapon, shooter));
        fire.setWeapon(weapon);
        fire.setFireDamageMultiply(WeaponHelper.modifyStat(WeaponStats.FIRE_DAMAGE, weapon, 0.0f));
        float explosionAmount = WeaponHelper.modifyStat(WeaponStats.EXPLOSION_DAMAGE, weapon, 0.0f);
        if (explosionAmount > 0.0f) {
            fire.setExplodeMultiply(this.getWeaponBaseDamage(weapon) * 0.3f * explosionAmount);
        }
        if (WeaponHelper.modifyStat(WeaponStats.RICOCHET, weapon, 0.0f) == 1.0f) {
            fire.markRicochetable();
        }
        return fire;
    }

    public PlasmaBolt spawnProjectile(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        PlasmaBolt fire = this.getDefaultProjectile(weapon, shooter, position, dir, shot);
        shooter.field_70170_p.func_72838_d((Entity)fire);
        if (shooter.field_70170_p.field_72995_K && shooter instanceof EntityPlayer) {
            ((ClientWeaponHandler)MatterOverdrive.PROXY.getWeaponHandler()).addPlasmaBolt(fire);
        }
        return fire;
    }

    @Override
    public int getRange(ItemStack weapon) {
        int range = this.defaultRange;
        range = Math.round(this.modifyStatFromModules(WeaponStats.RANGE, weapon, range));
        return range *= this.getCustomIntStat(weapon, CUSTOM_RANGE_MULTIPLY_TAG, 1);
    }

    @Override
    public int getShootCooldown(ItemStack weapon) {
        int shootCooldown = this.getCustomIntStat(weapon, CUSTOM_SPEED_TAG, this.getBaseShootCooldown(weapon));
        shootCooldown = (int)this.modifyStatFromModules(WeaponStats.FIRE_RATE, weapon, shootCooldown);
        return (shootCooldown = (int)((float)shootCooldown * this.getCustomFloatStat(weapon, CUSTOM_SPEED_MULTIPLY_TAG, 1.0f))) == 0 ? 1 : shootCooldown;
    }

    @SideOnly(value=Side.CLIENT)
    public WeaponShot createClientShot(ItemStack weapon, EntityLivingBase shooter, boolean zoomed) {
        return ((ClientWeaponHandler)MatterOverdrive.PROXY.getWeaponHandler()).getNextShot(weapon, this, shooter, zoomed);
    }

    public WeaponShot createServerShot(ItemStack weaponStack, EntityLivingBase shooter, boolean zoomed) {
        return new WeaponShot(field_77697_d.nextInt(), this.getWeaponScaledDamage(weaponStack, shooter), this.getAccuracy(weaponStack, shooter, zoomed), WeaponHelper.getColor(weaponStack), this.getRange(weaponStack));
    }

    public float modifyStatFromModules(IWeaponStat statID, ItemStack weapon, float original) {
        return WeaponHelper.modifyStat(statID, weapon, original);
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    public float getWeaponScaledDamage(ItemStack weapon, EntityLivingBase shooter) {
        float damage = this.getCustomFloatStat(weapon, CUSTOM_DAMAGE_TAG, this.getWeaponBaseDamage(weapon));
        damage = this.modifyStatFromModules(WeaponStats.DAMAGE, weapon, damage);
        damage += damage * (float)EnchantmentHelper.func_77506_a((Enchantment)MatterOverdriveEnchantments.overclock, (ItemStack)weapon) * 0.04f;
        damage *= this.getCustomFloatStat(weapon, CUSTOM_DAMAGE_MULTIPLY_TAG, 1.0f);
        damage = (float)((double)damage + shooter.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        return damage;
    }

    public DamageSource getDamageSource(ItemStack weapon, EntityPlayer player) {
        EntityDamageSourcePhaser damageInfo = new EntityDamageSourcePhaser((Entity)player);
        if (WeaponHelper.hasStat(WeaponStats.FIRE_RATE, weapon)) {
            damageInfo.func_76361_j();
        } else if (WeaponHelper.hasStat(WeaponStats.HEAL, weapon)) {
            damageInfo.func_82726_p();
        }
        if (WeaponHelper.hasStat(WeaponStats.EXPLOSION_DAMAGE, weapon)) {
            damageInfo.func_94540_d();
        }
        return damageInfo;
    }

    public int getEnergyUse(ItemStack weapon) {
        float energyUse = this.modifyStatFromModules(WeaponStats.AMMO, weapon, this.getBaseEnergyUse(weapon));
        energyUse -= energyUse * (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"unbreaking"), (ItemStack)weapon) * 0.04f;
        return Math.max((int)energyUse, 0);
    }

    public void addHeat(ItemStack itemStack, int amount) {
        if (itemStack.func_77942_o()) {
            this.setHeat(itemStack, this.getHeat(itemStack) + (float)amount);
        }
    }

    public void setHeat(ItemStack item, float amount) {
        item.func_77983_a("heat", (NBTBase)new NBTTagFloat(Math.min(amount, this.getMaxHeat(item) + 1.0f)));
    }

    @Override
    public float getHeat(ItemStack item) {
        if (item.func_77942_o()) {
            return item.func_77978_p().func_74760_g("heat");
        }
        return 0.0f;
    }

    @Override
    public float getMaxHeat(ItemStack weapon) {
        return this.modifyStatFromModules(WeaponStats.MAX_HEAT, weapon, this.getBaseMaxHeat(weapon));
    }

    public boolean isOverheated(ItemStack weapon) {
        return weapon.func_77942_o() && weapon.func_77978_p().func_74767_n("Overheated");
    }

    protected void setOverheated(ItemStack weapon, boolean overheated) {
        if (weapon.func_77942_o()) {
            weapon.func_77978_p().func_74757_a("Overheated", overheated);
        }
    }

    @Override
    public int getAmmo(ItemStack weapon) {
        return EnergyWeapon.getStorage(weapon).getEnergyStored();
    }

    @Override
    public float getAccuracy(ItemStack weapon, EntityLivingBase shooter, boolean zoomed) {
        ItemStack sights;
        float accuracy = this.getWeaponBaseAccuracy(weapon, zoomed);
        accuracy = this.getCustomFloatStat(weapon, CUSTOM_ACCURACY_TAG, accuracy);
        accuracy += (float)new Vec3d(shooter.field_70159_w, shooter.field_70181_x * 0.1, shooter.field_70179_y).func_72433_c() * 10.0f;
        accuracy *= shooter.func_70093_af() ? 0.6f : 1.0f;
        accuracy = this.modifyStatFromModules(WeaponStats.ACCURACY, weapon, accuracy);
        if (WeaponHelper.hasModule(3, weapon) && !(sights = WeaponHelper.getModuleAtSlot(3, weapon)).func_190926_b() && sights.func_77973_b() instanceof IWeaponScope) {
            accuracy = ((IWeaponScope)sights.func_77973_b()).getAccuracyModify(sights, weapon, zoomed, accuracy);
        }
        return accuracy *= this.getCustomFloatStat(weapon, CUSTOM_ACCURACY_MULTIPLY_TAG, 1.0f);
    }

    public void removeAllCustomStats(ItemStack weapon) {
        if (weapon.func_77942_o()) {
            weapon.func_77978_p().func_82580_o(CUSTOM_DAMAGE_TAG);
            weapon.func_77978_p().func_82580_o(CUSTOM_ACCURACY_TAG);
        }
    }

    public float getCustomFloatStat(ItemStack weapon, String name, float def) {
        if (weapon.func_77942_o() && weapon.func_77978_p().func_150297_b(name, 5)) {
            return weapon.func_77978_p().func_74760_g(name);
        }
        return def;
    }

    public int getCustomIntStat(ItemStack weapon, String name, int def) {
        if (weapon.func_77942_o() && weapon.func_77978_p().func_150297_b(name, 3)) {
            return weapon.func_77978_p().func_74762_e(name);
        }
        return def;
    }

    @Override
    public int getMaxAmmo(ItemStack weapon) {
        return EnergyWeapon.getStorage(weapon).getMaxEnergyStored();
    }

    public boolean needsRecharge(ItemStack weapon) {
        return !this.DrainEnergy(weapon, this.getShootCooldown(weapon), true);
    }

    protected boolean DrainEnergy(ItemStack item, float ticks, boolean simulate) {
        int amount;
        IEnergyStorage container = EnergyWeapon.getStorage(item);
        int hasEnergy = container.getEnergyStored();
        if (hasEnergy >= amount) {
            for (amount = MathHelper.func_76123_f((float)((float)this.getEnergyUse(item) * ticks)); amount > 0; amount -= container.extractEnergy(amount, simulate)) {
                if (container.extractEnergy(amount, true) > 0) {
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public int func_77619_b() {
        return Item.ToolMaterial.IRON.func_77995_e();
    }

    @Override
    public float getZoomMultiply(EntityPlayer entityPlayer, ItemStack weapon) {
        ItemStack sights;
        if (WeaponHelper.hasModule(3, weapon) && !(sights = WeaponHelper.getModuleAtSlot(3, weapon)).func_190926_b() && sights.func_77973_b() instanceof IWeaponScope) {
            return ((IWeaponScope)sights.func_77973_b()).getZoomAmount(sights, weapon);
        }
        return this.getBaseZoom(weapon, (EntityLivingBase)entityPlayer);
    }

    @Override
    public ICapabilityProvider createProvider(ItemStack stack) {
        return new EnergyProvider(stack, this.getCapacity(), this.getInput(), this.getOutput());
    }

    public static class EnergyProvider
    implements ICapabilityProvider {
        private EnergyContainer container;
        private ItemStack stack;

        public EnergyProvider(ItemStack stack, int capacity, int in, int out) {
            this.stack = stack;
            this.container = new EnergyContainer(capacity, in, out).setItemStack(stack);
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            ItemStack battery;
            if (capability != CapabilityEnergy.ENERGY) {
                return null;
            }
            if (!this.stack.func_190926_b() && (battery = WeaponHelper.getModuleAtSlot(0, this.stack)).hasCapability(capability, null)) {
                return (T)battery.getCapability(capability, null);
            }
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.container);
        }
    }
}

