/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.api.weapon.WeaponStats;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;

public class PlasmaShotgun
extends EnergyWeapon {
    public static final int RANGE = 16;
    private static final int MAX_CHARGE_TIME = 20;
    private static final int ENERGY_PER_SHOT = 2560;
    @SideOnly(value=Side.CLIENT)
    private MOPositionedSound lastChargingSound;

    public PlasmaShotgun(String name) {
        super(name, 16);
        this.func_77664_n();
        this.leftClickFire = true;
    }

    @Override
    protected int getCapacity() {
        return 32000;
    }

    @Override
    protected int getInput() {
        return 128;
    }

    @Override
    protected int getOutput() {
        return 128;
    }

    @Override
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
    }

    @Override
    public int getBaseEnergyUse(ItemStack item) {
        return 2560 / this.getShootCooldown(item);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 80;
    }

    @Override
    public float getWeaponBaseDamage(ItemStack weapon) {
        return 16.0f;
    }

    @Override
    public float getWeaponBaseAccuracy(ItemStack weapon, boolean zoomed) {
        return 5.0f + this.getHeat(weapon) * 0.3f;
    }

    @Override
    public boolean canFire(ItemStack itemStack, World world, EntityLivingBase shooter) {
        return this.DrainEnergy(itemStack, this.getShootCooldown(itemStack), true) && !this.isOverheated(itemStack) && !this.isEntitySpectator(shooter);
    }

    @Override
    public float getShotSpeed(ItemStack weapon, EntityLivingBase shooter) {
        return 3.0f;
    }

    @Override
    public int getBaseShootCooldown(ItemStack weapon) {
        return 22;
    }

    @Override
    public float getBaseZoom(ItemStack weapon, EntityLivingBase shooter) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientShot(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        MOPositionedSound sound = new MOPositionedSound(MatterOverdriveSounds.weaponsPlasmaShotgunShot, SoundCategory.PLAYERS, 0.3f + field_77697_d.nextFloat() * 0.2f, 0.9f + field_77697_d.nextFloat() * 0.2f);
        sound.setPosition((float)position.field_72450_a, (float)position.field_72448_b, (float)position.field_72449_c);
        Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)sound, 1);
        this.spawnProjectiles(weapon, shooter, position, dir, shot);
    }

    public PlasmaBolt[] spawnProjectiles(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        PlasmaBolt[] bolts = new PlasmaBolt[shot.getCount()];
        for (int i = 0; i < shot.getCount(); ++i) {
            WeaponShot newShot = new WeaponShot(shot);
            if (shooter.field_70170_p.field_72995_K) {
                newShot.setSeed(((ClientWeaponHandler)MatterOverdrive.PROXY.getWeaponHandler()).getNextShotID());
            } else {
                newShot.setSeed(shot.getSeed() + i);
            }
            newShot.setDamage(shot.getDamage() / (float)shot.getCount());
            bolts[i] = new PlasmaBolt(shooter.field_70170_p, shooter, position, dir, newShot, this.getShotSpeed(weapon, shooter));
            bolts[i].setWeapon(weapon);
            bolts[i].setRenderSize((float)(this.getShotCount(weapon, shooter) / shot.getCount()) * 0.5f);
            bolts[i].setFireDamageMultiply(WeaponHelper.modifyStat(WeaponStats.FIRE_DAMAGE, weapon, 0.0f));
            float explosionMultiply = WeaponHelper.modifyStat(WeaponStats.EXPLOSION_DAMAGE, weapon, 0.0f);
            if (explosionMultiply > 0.0f) {
                bolts[i].setExplodeMultiply(this.getWeaponBaseDamage(weapon) * 0.3f * explosionMultiply / (float)shot.getCount());
            }
            bolts[i].setKnockBack(0.5f);
            if (WeaponHelper.modifyStat(WeaponStats.RICOCHET, weapon, 0.0f) == 1.0f) {
                bolts[i].markRicochetable();
            }
            shooter.field_70170_p.func_72838_d((Entity)bolts[i]);
        }
        return bolts;
    }

    public int getShotCount(ItemStack weapon, EntityLivingBase shooter) {
        return 10;
    }

    @Override
    public void onProjectileHit(RayTraceResult hit, ItemStack weapon, World world, float amount) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(60.0f, 45.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
            case 3: {
                return new Vector2f(150.0f, 35.0f);
            }
        }
        return new Vector2f(205.0f, (float)(80 + (slot - 4) * 22));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(165.0f, 80.0f);
            }
            case 1: {
                return new Vector2f(100.0f, 80.0f);
            }
            case 2: {
                return new Vector2f(90.0f, 90.0f);
            }
            case 3: {
                return new Vector2f(140.0f, 72.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return true;
    }

    @Override
    public boolean supportsModule(ItemStack weapon, ItemStack module) {
        return !module.func_190926_b() && (module.func_77973_b() == MatterOverdrive.ITEMS.weapon_module_color || module.func_77973_b() == MatterOverdrive.ITEMS.weapon_module_barrel && module.func_77952_i() != 3);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (hand == EnumHand.OFF_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        if (worldIn.field_72995_K && this.canFire(itemStackIn, worldIn, (EntityLivingBase)playerIn) && this.hasShootDelayPassed() && playerIn.func_184600_cs() != EnumHand.MAIN_HAND) {
            playerIn.func_184598_c(hand);
            this.playChargingSound(playerIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void playChargingSound(EntityPlayer entityPlayer) {
        this.lastChargingSound = new MOPositionedSound(MatterOverdriveSounds.weaponsPlasmaShotgunCharging, SoundCategory.PLAYERS, 3.0f + field_77697_d.nextFloat() * 0.2f, 0.9f * field_77697_d.nextFloat() * 0.2f);
        this.lastChargingSound.setPosition((float)entityPlayer.field_70165_t, (float)entityPlayer.field_70163_u, (float)entityPlayer.field_70161_v);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.lastChargingSound);
    }

    @SideOnly(value=Side.CLIENT)
    public void stopChargingSound() {
        Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.lastChargingSound);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (worldIn.field_72995_K) {
            int maxCount = this.getShotCount(stack, entityLiving);
            int timeElapsed = this.func_77626_a(stack) - timeLeft;
            int count = Math.max(1, (int)((1.0f - (float)timeElapsed / 20.0f) * (float)maxCount));
            float shotPercent = (float)count / (float)this.getShotCount(stack, entityLiving);
            ClientProxy.instance().getClientWeaponHandler().setCameraRecoil(0.3f + this.getAccuracy(stack, entityLiving, true) * 0.1f, 1.0f);
            Vec3d dir = entityLiving.func_70676_i(1.0f);
            Vec3d pos = this.getFirePosition(entityLiving, dir, Mouse.isButtonDown((int)1));
            WeaponShot shot = this.createShot(stack, entityLiving, Mouse.isButtonDown((int)1));
            shot.setCount(count);
            shot.setAccuracy(shot.getAccuracy() * shotPercent);
            shot.setRange(shot.getRange() + (int)((float)shot.getRange() * (1.0f - shotPercent)));
            this.onClientShot(stack, entityLiving, pos, dir, shot);
            MatterOverdrive.NETWORK.sendToServer(new PacketFirePlasmaShot(entityLiving.func_145782_y(), pos, dir, shot));
            this.addShootDelay(stack);
            ClientProxy.instance().getClientWeaponHandler().setRecoil((float)(15 + (maxCount - count) * 2) + this.getAccuracy(stack, entityLiving, this.isWeaponZoomed(entityLiving, stack)) * 2.0f, 1.0f + (float)(maxCount - count) * 0.03f, 0.3f);
            this.stopChargingSound();
            entityLiving.func_184602_cy();
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase playerIn) {
        return stack;
    }

    public int func_77626_a(ItemStack weapon) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFirePosition(EntityLivingBase entityPlayer, Vec3d dir, boolean isAiming) {
        Vec3d pos = entityPlayer.func_174824_e(1.0f);
        if (!isAiming) {
            // empty if block
        }
        pos = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        return pos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack itemStack, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (Mouse.isButtonDown((int)0) && this.hasShootDelayPassed()) {
            if (this.canFire(itemStack, world, (EntityLivingBase)entityPlayer)) {
                itemStack.func_77983_a("LastShot", (NBTBase)new NBTTagLong(world.func_82737_E()));
                Vec3d dir = entityPlayer.func_70676_i(1.0f);
                Vec3d pos = this.getFirePosition((EntityLivingBase)entityPlayer, dir, Mouse.isButtonDown((int)1));
                WeaponShot shot = this.createShot(itemStack, (EntityLivingBase)entityPlayer, Mouse.isButtonDown((int)1));
                this.onClientShot(itemStack, (EntityLivingBase)entityPlayer, pos, dir, shot);
                this.addShootDelay(itemStack);
                this.sendShootTickToServer(world, shot, dir, pos);
                ClientProxy.instance().getClientWeaponHandler().setRecoil(12.0f + this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, this.isWeaponZoomed((EntityLivingBase)entityPlayer, itemStack)) * 2.0f, 1.0f, 0.2f);
                Minecraft.func_71410_x().field_71439_g.field_70737_aN = 15;
                Minecraft.func_71410_x().field_71439_g.field_70738_aO = 30;
                return;
            }
            if (this.needsRecharge(itemStack)) {
                this.chargeFromEnergyPack(itemStack, entityPlayer);
            }
        }
        super.onShooterClientUpdate(itemStack, world, entityPlayer, sendServerTick);
    }

    public WeaponShot createShot(ItemStack weapon, EntityLivingBase shooter, boolean zoomed) {
        WeaponShot shot = new WeaponShot(field_77697_d.nextInt(), this.getWeaponScaledDamage(weapon, shooter), this.getAccuracy(weapon, shooter, zoomed), WeaponHelper.getColor(weapon), this.getRange(weapon));
        shot.setCount(this.getShotCount(weapon, shooter));
        return shot;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityLivingBase shooter, WeaponShot shot, Vec3d position, Vec3d dir, int delay) {
        PlasmaBolt[] fires;
        this.DrainEnergy(weapon, this.getShootCooldown(weapon), false);
        int heatAdd = (this.getShotCount(weapon, shooter) - shot.getCount()) * 2;
        float newHeat = (this.getHeat(weapon) + (float)heatAdd + 6.0f) * 4.2f;
        this.setHeat(weapon, Math.max(newHeat, 0.0f));
        this.manageOverheat(weapon, shooter.field_70170_p, shooter);
        for (PlasmaBolt bolt : fires = this.spawnProjectiles(weapon, shooter, position, dir, shot)) {
            bolt.simulateDelay(delay);
        }
        return true;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWeaponZoomed(EntityLivingBase entityPlayer, ItemStack weapon) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WeaponSound getFireSound(ItemStack weapon, EntityLivingBase entity) {
        return null;
    }
}

