/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.components;

import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkFilter;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.DestinationFilterSlot;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineComponentAbstract;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import net.minecraft.nbt.NBTTagCompound;

public class ComponentMatterNetworkConfigs
extends MachineComponentAbstract<MOTileEntityMachine> {
    private String destinationFilter;
    private int destinationFilterSlot;

    public ComponentMatterNetworkConfigs(MOTileEntityMachine machine) {
        super(machine);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.CONFIGS) && nbt.func_150297_b("DestinationFilter", 8)) {
            this.destinationFilter = nbt.func_74779_i("DestinationFilter");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (categories.contains((Object)MachineNBTCategory.CONFIGS) && this.destinationFilter != null) {
            nbt.func_74778_a("DestinationFilter", this.destinationFilter);
        }
    }

    @Override
    public void registerSlots(Inventory inventory) {
        this.destinationFilterSlot = inventory.AddSlot(new DestinationFilterSlot(false));
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onMachineEvent(MachineEvent event) {
    }

    public NBTTagCompound getFilter() {
        if (this.machine.func_70301_a(this.destinationFilterSlot) != null && this.machine.func_70301_a(this.destinationFilterSlot).func_77973_b() instanceof IMatterNetworkFilter) {
            return ((IMatterNetworkFilter)this.machine.func_70301_a(this.destinationFilterSlot).func_77973_b()).getFilter(this.machine.func_70301_a(this.destinationFilterSlot));
        }
        return null;
    }

    public int getDestinationFilterSlot() {
        return this.destinationFilterSlot;
    }

    public String getDestinationFilter() {
        return this.destinationFilter;
    }

    public void setDestinationFilter(String destinationFilter) {
        this.destinationFilter = destinationFilter;
    }
}

