/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.decomposer;

import java.util.EnumSet;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.MatterSlot;
import matteroverdrive.data.inventory.RemoveOnlySlot;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;

public class TileEntityMachineDecomposer
extends MOTileEntityMachineMatter
implements ISidedInventory {
    public static final int MATTER_EXTRACT_SPEED = 32;
    public static final float FAIL_CHANGE = 0.005f;
    private static final Random random = new Random();
    public static int MATTER_STORAGE = 1024;
    public static int ENERGY_STORAGE = 512000;
    public static int DECEOPOSE_SPEED_PER_MATTER = 80;
    public static int DECOMPOSE_ENERGY_PER_MATTER = 6000;
    private static EnumSet<UpgradeTypes> upgradeTypes = EnumSet.of(UpgradeTypes.Fail, new UpgradeTypes[]{UpgradeTypes.MatterStorage, UpgradeTypes.MatterTransfer, UpgradeTypes.PowerStorage, UpgradeTypes.PowerUsage, UpgradeTypes.Speed});
    private final TimeTracker time;
    public int INPUT_SLOT_ID;
    public int OUTPUT_SLOT_ID;
    public int decomposeTime;

    public TileEntityMachineDecomposer() {
        super(4);
        this.energyStorage.setCapacity(ENERGY_STORAGE);
        this.energyStorage.setMaxExtract(ENERGY_STORAGE);
        this.energyStorage.setMaxReceive(ENERGY_STORAGE);
        this.matterStorage.setCapacity(MATTER_STORAGE);
        this.matterStorage.setMaxReceive(0);
        this.matterStorage.setMaxExtract(MATTER_STORAGE);
        this.time = new TimeTracker();
        this.playerSlotsMain = true;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.INPUT_SLOT_ID = inventory.AddSlot(new MatterSlot(true));
        this.OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false));
        super.RegisterSlots(inventory);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.manageDecompose();
        this.manageExtract();
    }

    @Override
    public SoundEvent getSound() {
        return MatterOverdriveSounds.decomposer;
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public float soundVolume() {
        return 0.3f;
    }

    private void manageExtract() {
        if (!this.field_145850_b.field_72995_K && this.time.hasDelayPassed(this.field_145850_b, 32)) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                int received;
                TileEntity e = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
                EnumFacing opposite = dir.func_176734_d();
                if (e == null || !e.hasCapability(MatterOverdriveCapabilities.MATTER_HANDLER, opposite) || (received = ((IMatterHandler)e.getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, opposite)).receiveMatter(this.matterStorage.getFluidAmount(), false)) == 0) continue;
                this.matterStorage.setMatterStored(Math.max(0, this.matterStorage.getMatterStored() - received));
                this.updateClientMatter();
            }
        }
    }

    protected void manageDecompose() {
        if (!this.field_145850_b.field_72995_K && this.isDecomposing() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick()) {
            ++this.decomposeTime;
            this.getEnergyStorage().extractEnergy(this.getEnergyDrainPerTick(), false);
            if (this.decomposeTime >= this.getSpeed()) {
                this.decomposeTime = 0;
                this.decomposeItem();
            }
        }
        if (!this.isDecomposing()) {
            this.decomposeTime = 0;
        }
    }

    public boolean isDecomposing() {
        int matter = MatterHelper.getMatterAmountFromItem(this.func_70301_a(this.INPUT_SLOT_ID));
        return this.getRedstoneActive() && !this.func_70301_a(this.INPUT_SLOT_ID).func_190926_b() && MatterHelper.containsMatter(this.func_70301_a(this.INPUT_SLOT_ID)) && this.func_94041_b(this.INPUT_SLOT_ID, this.func_70301_a(this.INPUT_SLOT_ID)) && matter <= this.matterStorage.getCapacity() - this.matterStorage.getMatterStored() && this.canPutInOutput(matter);
    }

    @Override
    public boolean getServerActive() {
        return this.isDecomposing() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick();
    }

    public double getFailChance() {
        double upgradeMultiply = this.getUpgradeMultiply(UpgradeTypes.Fail);
        return (double)0.005f * upgradeMultiply * upgradeMultiply;
    }

    public int getSpeed() {
        double matter = Math.log1p(MatterHelper.getMatterAmountFromItem(this.inventory.func_70301_a(this.INPUT_SLOT_ID)));
        matter *= matter;
        return (int)Math.round((matter + 6.0) * (double)DECEOPOSE_SPEED_PER_MATTER * this.getUpgradeMultiply(UpgradeTypes.Speed));
    }

    public int getEnergyDrainPerTick() {
        int speed = this.getSpeed();
        return this.getEnergyDrainMax() / speed;
    }

    public int getEnergyDrainMax() {
        int matter = MatterHelper.getMatterAmountFromItem(this.inventory.func_70301_a(this.INPUT_SLOT_ID));
        double upgradeMultiply = this.getUpgradeMultiply(UpgradeTypes.PowerUsage);
        return (int)Math.round(Math.log1p((double)matter * 0.01) * 15.0 * (double)DECOMPOSE_ENERGY_PER_MATTER * upgradeMultiply);
    }

    private boolean canPutInOutput(int matter) {
        ItemStack stack = this.func_70301_a(this.OUTPUT_SLOT_ID);
        if (stack.func_190926_b()) {
            return true;
        }
        return stack.func_77973_b() == MatterOverdrive.ITEMS.matter_dust && stack.func_77952_i() == matter && stack.func_190916_E() < stack.func_77976_d();
    }

    private void failDecompose() {
        ItemStack stack = this.func_70301_a(this.OUTPUT_SLOT_ID);
        int matter = MatterHelper.getMatterAmountFromItem(this.func_70301_a(this.INPUT_SLOT_ID));
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == MatterOverdrive.ITEMS.matter_dust && stack.func_77952_i() == matter && stack.func_190916_E() < stack.func_77976_d()) {
                stack.func_190917_f(1);
            }
        } else {
            stack = new ItemStack((Item)MatterOverdrive.ITEMS.matter_dust);
            MatterOverdrive.ITEMS.matter_dust.setMatter(stack, matter);
            this.func_70299_a(this.OUTPUT_SLOT_ID, stack);
        }
    }

    private void decomposeItem() {
        int matterAmount = MatterHelper.getMatterAmountFromItem(this.func_70301_a(this.INPUT_SLOT_ID));
        if (!this.func_70301_a(this.INPUT_SLOT_ID).func_190926_b() && this.canPutInOutput(matterAmount)) {
            if ((double)random.nextFloat() < this.getFailChance()) {
                this.failDecompose();
            } else {
                int matter = this.matterStorage.getMatterStored();
                this.matterStorage.setMatterStored(matterAmount + matter);
                this.updateClientMatter();
            }
            this.func_70298_a(this.INPUT_SLOT_ID, 1);
            this.forceSync();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.decomposeTime = nbt.func_74765_d("DecomposeTime");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74777_a("DecomposeTime", (short)this.decomposeTime);
        }
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{this.INPUT_SLOT_ID, this.OUTPUT_SLOT_ID};
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == this.OUTPUT_SLOT_ID;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return upgradeTypes.contains((Object)type);
    }

    @Override
    public float getProgress() {
        float speed = this.getSpeed();
        if (speed > 0.0f) {
            return (float)this.decomposeTime / speed;
        }
        return 0.0f;
    }
}

