/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.dimensional_pylon;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.multiblock.MultiblockFormEvent;
import matteroverdrive.blocks.BlockPylon;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.fx.LightningCircle;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.dimensional_pylon.ComponentPowerGeneration;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.TileUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineDimensionalPylon
extends MOTileEntityMachineMatter {
    public static int MAX_CHARGE = 2048;
    BlockPos mainBlock;
    List<BlockPos> children;
    ComponentPowerGeneration powerGeneration;
    int charge;

    public TileEntityMachineDimensionalPylon() {
        super(4);
        this.matterStorage.setCapacity(2048);
        this.matterStorage.setMaxExtract(0);
        this.matterStorage.setMaxReceive(128);
        this.energyStorage.setCapacity(1000000);
        this.energyStorage.setMaxExtract(2048);
        this.energyStorage.setMaxReceive(0);
    }

    @Override
    public SoundEvent getSound() {
        return MatterOverdriveSounds.blocksPylon;
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public boolean getServerActive() {
        return this.mainBlock != null && this.children != null && this.children.size() > 0;
    }

    @Override
    public float soundVolume() {
        return 0.3f * this.getDimensionalValue();
    }

    @Override
    protected void registerComponents() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            super.registerComponents();
        }
    }

    private void registerPylonComponents() {
        super.registerComponents();
        this.powerGeneration = new ComponentPowerGeneration(this);
        this.addComponent(this.powerGeneration);
    }

    public float getDimensionalValue() {
        if (this.mainBlock != null) {
            return MatterOverdrive.MO_WORLD.getDimensionalRifts().getValueAt(this.mainBlock);
        }
        return MatterOverdrive.MO_WORLD.getDimensionalRifts().getValueAt(this.func_174877_v());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.manageLightningClientLightning();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void manageLightningClientLightning() {
        if (this.isActive()) {
            Color color = RenderUtils.lerp(Reference.COLOR_MATTER.multiplyWithoutAlpha(0.5f), Reference.COLOR_HOLO_RED, (float)this.charge / (float)MAX_CHARGE);
            if (this.func_145831_w().func_72820_D() % 2L == 0L) {
                float dimValue = this.getDimensionalValue();
                if ((float)random.nextInt(10) < dimValue) {
                    double y = (double)this.func_174877_v().func_177956_o() + 0.5 + random.nextDouble() * 2.0;
                    double dirX = MathHelper.func_151237_a((double)random.nextGaussian(), (double)-1.0, (double)1.0) * 0.1;
                    double dirZ = MathHelper.func_151237_a((double)random.nextGaussian(), (double)-1.0, (double)1.0) * 0.1;
                    LightningCircle lightning = new LightningCircle(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() - dirX, y, (double)this.func_174877_v().func_177952_p() - dirZ, 0.03f, 1.0f, 0.3f, 0.2f);
                    lightning.setColorRGBA(color);
                    ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(lightning, RenderParticlesHandler.Blending.LinesAdditive);
                }
            }
        }
    }

    public void addCharge(int charge) {
        if (this.mainBlock != null && !this.mainBlock.equals((Object)this.func_174877_v())) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.mainBlock);
            if (tileEntity != null && tileEntity instanceof TileEntityMachineDimensionalPylon) {
                ((TileEntityMachineDimensionalPylon)tileEntity).addCharge(charge);
            }
        } else {
            this.charge += charge;
            this.forceSync();
        }
    }

    public int removeCharge(int charge) {
        if (this.mainBlock != null && !this.mainBlock.equals((Object)this.func_174877_v())) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.mainBlock);
            if (tileEntity != null && tileEntity instanceof TileEntityMachineDimensionalPylon) {
                return ((TileEntityMachineDimensionalPylon)tileEntity).removeCharge(charge);
            }
        } else {
            charge = Math.min(this.charge, charge);
            this.charge -= charge;
            if (charge != 0) {
                this.forceSync();
            }
            return charge;
        }
        return 0;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            if (this.mainBlock != null && toDisk) {
                nbt.func_74772_a("mainBlock", this.mainBlock.func_177986_g());
            }
            nbt.func_74777_a("charge", (short)this.charge);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            if (nbt.func_74764_b("mainBlock")) {
                this.mainBlock = BlockPos.func_177969_a((long)nbt.func_74763_f("mainBlock"));
            }
            if (nbt.func_74764_b("charge")) {
                this.charge = nbt.func_74765_d("charge");
            }
        }
    }

    @Override
    public boolean isActive() {
        TileEntity tileEntity;
        if (this.isPartOfStructure() && !this.mainBlock.equals((Object)this.func_174877_v()) && (tileEntity = this.field_145850_b.func_175625_s(this.mainBlock)) != null && tileEntity instanceof TileEntityMachineDimensionalPylon) {
            return ((TileEntityMachineDimensionalPylon)tileEntity).isActive();
        }
        return super.isActive();
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction.equals((Object)EnumFacing.DOWN);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (direction.equals((Object)EnumFacing.DOWN)) {
            return this.func_94041_b(index, itemStackIn);
        }
        return false;
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
        if (event instanceof MachineEvent.Destroyed) {
            TileEntity tileEntity;
            if (this.children != null) {
                this.invalidateChildren();
            } else if (this.mainBlock != null && !this.mainBlock.equals((Object)this.func_174877_v()) && (tileEntity = this.field_145850_b.func_175625_s(this.mainBlock)) instanceof TileEntityMachineDimensionalPylon) {
                ((TileEntityMachineDimensionalPylon)tileEntity).removeChild(this.func_174877_v());
            }
        } else if (event instanceof MachineEvent.Awake && this.mainBlock != null) {
            this.components.clear();
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.mainBlock);
            if (tileEntity instanceof TileEntityMachineDimensionalPylon) {
                if (tileEntity != this) {
                    TileEntityMachineDimensionalPylon tileEntityDimensionalPylon = (TileEntityMachineDimensionalPylon)tileEntity;
                    tileEntityDimensionalPylon.addChild(this.func_174877_v());
                    this.matterStorage = tileEntityDimensionalPylon.matterStorage;
                    this.energyStorage = tileEntityDimensionalPylon.getEnergyStorage();
                } else {
                    this.registerPylonComponents();
                }
            } else {
                this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockPylon.TYPE, (Comparable)((Object)BlockPylon.MultiblockType.NORMAL)));
                this.removeMainBlock();
            }
        }
    }

    public void addChild(BlockPos pos) {
        if (this.children == null) {
            this.children = new ArrayList<BlockPos>();
            this.registerPylonComponents();
        }
        if (!this.children.contains(pos)) {
            this.children.add(pos);
        }
    }

    public void removeChild(BlockPos child) {
        if (this.children != null) {
            this.children.remove(child);
        }
        this.invalidateChildren();
    }

    public void invalidateChildren() {
        IBlockState state;
        if (this.children != null) {
            for (BlockPos pos : this.children) {
                IBlockState state2 = this.field_145850_b.func_180495_p(pos);
                TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
                this.field_145850_b.func_175656_a(pos, state2.func_177226_a(BlockPylon.TYPE, (Comparable)((Object)BlockPylon.MultiblockType.NORMAL)));
                if (!(tileEntity instanceof TileEntityMachineDimensionalPylon)) continue;
                ((TileEntityMachineDimensionalPylon)tileEntity).removeMainBlock();
            }
        }
        if ((state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() instanceof BlockPylon) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), state.func_177226_a(BlockPylon.TYPE, (Comparable)((Object)BlockPylon.MultiblockType.NORMAL)));
        }
        this.children = null;
        this.removeMainBlock();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    public boolean onWrenchHit(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.mainBlock == null) {
            return this.tryFormStructure(world, stack, player, pos);
        }
        return false;
    }

    public boolean openMultiBlockGui(World world, EntityPlayer entityPlayer) {
        TileEntity mainPylon;
        if (this.mainBlock != null && (mainPylon = world.func_175625_s(this.mainBlock)) instanceof TileEntityMachineDimensionalPylon) {
            if (((MOTileEntityMachine)mainPylon).func_70300_a(entityPlayer)) {
                FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)MatterOverdrive.INSTANCE, (int)-1, (World)world, (int)this.mainBlock.func_177958_n(), (int)this.mainBlock.func_177956_o(), (int)this.mainBlock.func_177952_p());
                return true;
            }
            TextComponentString message = new TextComponentString(TextFormatting.GOLD + "[Matter Overdrive] " + TextFormatting.RED + MOStringHelper.translateToLocal("alert.no_rights", new Object[0]).replace("$0", ((MOTileEntityMachine)mainPylon).func_145748_c_().toString()));
            message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            entityPlayer.func_145747_a((ITextComponent)message);
        }
        return false;
    }

    public boolean tryFormStructure(World world, ItemStack stack, EntityPlayer player, BlockPos pos) {
        int i;
        if (world.field_72995_K) {
            return false;
        }
        AxisAlignedBB bounds = new AxisAlignedBB(pos, pos);
        for (i = 0; i < 1; ++i) {
            if (this.isBlockConsumable(world, new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c).func_177982_a(-1, 0, 0))) {
                bounds = bounds.func_72321_a(-1.0, 0.0, 0.0);
            }
            if (!this.isBlockConsumable(world, new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f).func_177982_a(1, 0, 0))) continue;
            bounds = bounds.func_72321_a(1.0, 0.0, 0.0);
        }
        for (i = 0; i < 1; ++i) {
            if (this.isBlockConsumable(world, new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c).func_177982_a(0, 0, -1))) {
                bounds = bounds.func_72321_a(0.0, 0.0, -1.0);
            }
            if (!this.isBlockConsumable(world, new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f).func_177982_a(0, 0, 1))) continue;
            bounds = bounds.func_72321_a(0.0, 0.0, 1.0);
        }
        for (i = 0; i < 2; ++i) {
            if (this.isBlockConsumable(world, new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c).func_177982_a(0, -1, 0))) {
                bounds = bounds.func_72321_a(0.0, -1.0, 0.0);
            }
            if (!this.isBlockConsumable(world, new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f).func_177982_a(0, 1, 0))) continue;
            bounds = bounds.func_72321_a(0.0, 1.0, 0.0);
        }
        double xLength = bounds.field_72336_d - bounds.field_72340_a;
        double yLength = bounds.field_72337_e - bounds.field_72338_b;
        double zLength = bounds.field_72334_f - bounds.field_72339_c;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(12);
        BlockPos mainBlock = null;
        if (xLength == 1.0 && yLength == 2.0 && zLength == 1.0) {
            for (int x = 0; x <= 1; ++x) {
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 1; ++z) {
                        BlockPos p = new BlockPos(bounds.field_72340_a + (double)x, bounds.field_72338_b + (double)y, bounds.field_72339_c + (double)z);
                        if (!this.isBlockConsumable(world, p)) {
                            MOLog.info("Invalid Structure", new Object[0]);
                            return false;
                        }
                        if (x == 1 && y == 0 && z == 1) {
                            mainBlock = p;
                            continue;
                        }
                        positions.add(p);
                    }
                }
            }
        } else {
            MOLog.info("Invalid Structure", new Object[0]);
            return false;
        }
        if (mainBlock != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new MultiblockFormEvent(world, mainBlock, world.func_180495_p(mainBlock), MultiblockFormEvent.Multiblock.PYLON))) {
                return false;
            }
            BlockPos finalMainBlock = mainBlock;
            for (BlockPos p : positions) {
                IBlockState pylonBlockstate = world.func_180495_p(p);
                world.func_175656_a(p, pylonBlockstate.func_177226_a(BlockPylon.TYPE, (Comparable)((Object)BlockPylon.MultiblockType.DUMMY)));
                TileUtils.getTileEntity((IBlockAccess)world, p, TileEntityMachineDimensionalPylon.class).ifPresent(pylon -> pylon.setMainBlock(finalMainBlock));
            }
            IBlockState pylonBlockstate = world.func_180495_p(mainBlock);
            world.func_175656_a(mainBlock, pylonBlockstate.func_177226_a(BlockPylon.TYPE, (Comparable)((Object)BlockPylon.MultiblockType.MAIN)));
            TileUtils.getTileEntity((IBlockAccess)world, mainBlock, TileEntityMachineDimensionalPylon.class).ifPresent(pylon -> {
                pylon.children = positions;
                pylon.setMainBlock(finalMainBlock);
                pylon.registerPylonComponents();
            });
            MOLog.info("Valid Structure", new Object[0]);
            return true;
        }
        MOLog.info("Invalid Structure", new Object[0]);
        return false;
    }

    public void setMainBlock(BlockPos mainBlock) {
        this.mainBlock = new BlockPos((Vec3i)mainBlock);
        this.components.clear();
    }

    public void removeMainBlock() {
        this.mainBlock = null;
        this.components.clear();
    }

    private boolean isBlockConsumable(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMachineDimensionalPylon) {
            return !((TileEntityMachineDimensionalPylon)tileEntity).isPartOfStructure();
        }
        return false;
    }

    public boolean isPartOfStructure() {
        return this.mainBlock != null;
    }

    public boolean isMainStructureBlock() {
        return this.children != null && this.children.size() > 0;
    }

    public int getEnergyGenPerTick() {
        if (this.powerGeneration != null) {
            return this.powerGeneration.getEnergyGenPerTick();
        }
        return 0;
    }

    public int getMatterDrainPerSec() {
        if (this.powerGeneration != null) {
            return this.powerGeneration.getMatterDrainPerSec();
        }
        return 0;
    }

    public int getCharge() {
        return this.charge;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (!(facing != null && facing != EnumFacing.DOWN || capability != MatterOverdriveCapabilities.MATTER_HANDLER && capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (!(facing != null && facing != EnumFacing.DOWN || capability != MatterOverdriveCapabilities.MATTER_HANDLER && capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)this.matterStorage;
        }
        return super.getCapability(capability, facing);
    }
}

