/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.fusionReactorController.components;

import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.data.Inventory;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.machines.MachineComponentAbstract;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.machines.fusionReactorController.TileEntityMachineFusionReactorController;
import net.minecraft.nbt.NBTTagCompound;

public class ComponentComputers
extends MachineComponentAbstract<TileEntityMachineFusionReactorController> {
    private String[] methodNames = new String[]{"getStatus", "isValid", "getEnergyGenerated", "getMatterUsed", "getEnergyStored", "getMatterStored"};
    private String peripheralName = "mo_fusion_reactor_controller";

    public ComponentComputers(TileEntityMachineFusionReactorController machine) {
        super(machine);
    }

    private Object[] callMethod(int method, Object[] args) {
        switch (method) {
            case 0: {
                return this.computerGetStatus(args);
            }
            case 1: {
                return this.computerIsValid(args);
            }
            case 2: {
                return this.computerGetEnergyGenerated(args);
            }
            case 3: {
                return this.computerGetMatterUsed(args);
            }
            case 4: {
                return this.computerGetEnergyStored(args);
            }
            case 5: {
                return this.computerGetMatterStored(args);
            }
        }
        throw new IllegalArgumentException("Invalid method id");
    }

    private Object[] computerGetStatus(Object[] args) {
        return new Object[]{((TileEntityMachineFusionReactorController)this.machine).getMonitorInfo()};
    }

    private Object[] computerIsValid(Object[] args) {
        return new Object[]{((TileEntityMachineFusionReactorController)this.machine).isValidStructure()};
    }

    private Object[] computerGetEnergyGenerated(Object[] args) {
        return new Object[]{((TileEntityMachineFusionReactorController)this.machine).getEnergyPerTick()};
    }

    private Object[] computerGetMatterUsed(Object[] args) {
        return new Object[]{Float.valueOf(((TileEntityMachineFusionReactorController)this.machine).getMatterDrainPerTick())};
    }

    private Object[] computerGetEnergyStored(Object[] args) {
        return new Object[]{((TileEntityMachineFusionReactorController)this.machine).getEnergyStorage().getEnergyStored()};
    }

    private Object[] computerGetMatterStored(Object[] args) {
        return new Object[]{((TileEntityMachineFusionReactorController)this.machine).getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null).getMatterStored()};
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
    }

    @Override
    public void registerSlots(Inventory inventory) {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onMachineEvent(MachineEvent event) {
    }
}

