/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.replicator;

import java.util.EnumSet;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.blocks.BlockReplicator;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.replicator.TileEntityMachineReplicator;
import matteroverdrive.matter_network.components.TaskQueueComponent;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.network.packet.client.PacketReplicationComplete;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ComponentTaskProcessingReplicator
extends TaskQueueComponent<MatterNetworkTaskReplicatePattern, TileEntityMachineReplicator>
implements ITickable {
    public static final double FAIL_CHANCE = 0.005;
    public static int REPLICATE_SPEED_PER_MATTER = 120;
    public static int REPLICATE_ENERGY_PER_MATTER = 16000;
    private final TimeTracker radiationTimeTracker = new TimeTracker();
    private final Random random = new Random();
    public int replicateTime;
    private float replicateProgress;

    public ComponentTaskProcessingReplicator(String name, TileEntityMachineReplicator machine, int taskQueueCapacity) {
        super(name, machine, taskQueueCapacity, taskQueueCapacity);
    }

    public boolean addReplicationTask(MatterNetworkTaskReplicatePattern task) {
        return this.getTaskQueue().queue(task);
    }

    public void func_73660_a() {
        this.manageReplicate();
    }

    protected void manageReplicate() {
        if (this.isReplicating()) {
            if (!this.getWorld().field_72995_K) {
                MatterNetworkTaskReplicatePattern replicatePattern = (MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek();
                ItemStack patternStack = replicatePattern.getPattern().toItemStack(false);
                if (replicatePattern.isValid(this.getWorld())) {
                    if (((TileEntityMachineReplicator)this.machine).getEnergyStorage().getEnergyStored() >= this.getEnergyDrainPerTick()) {
                        replicatePattern.setState(MatterNetworkTaskState.PROCESSING);
                        ++this.replicateTime;
                        ((TileEntityMachineReplicator)this.machine).getEnergyStorage().extractEnergy(this.getEnergyDrainPerTick(patternStack), false);
                        int time = this.getSpeed(patternStack);
                        if (this.replicateTime >= time) {
                            this.replicateTime = 0;
                            this.replicateItem(replicatePattern.getPattern(), patternStack);
                            MatterOverdrive.NETWORK.sendToDimention((IMessage)new PacketReplicationComplete(this.machine), this.getWorld());
                            SoundHandler.PlaySoundAt(this.getWorld(), MatterOverdriveSounds.replicateSuccess, SoundCategory.BLOCKS, this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p(), 0.25f * ((TileEntityMachineReplicator)this.machine).getBlockType(BlockReplicator.class).replication_volume, 1.0f, 0.2f, 0.8f);
                        }
                        if (this.radiationTimeTracker.hasDelayPassed(this.getWorld(), 5)) {
                            ((TileEntityMachineReplicator)this.machine).manageRadiation();
                        }
                        this.replicateProgress = (float)this.replicateTime / (float)time;
                    }
                } else {
                    this.getTaskQueue().dequeue();
                }
            }
        } else {
            this.replicateTime = 0;
            this.replicateProgress = 0.0f;
        }
    }

    private void replicateItem(ItemPattern itemPattern, ItemStack newItem) {
        if (this.isActive()) {
            int matterAmount = MatterHelper.getMatterAmountFromItem(newItem);
            float chance = this.random.nextFloat();
            if ((double)chance < this.getFailChance(itemPattern)) {
                if (((TileEntityMachineReplicator)this.machine).failReplicate(MatterHelper.getMatterAmountFromItem(newItem))) {
                    IMatterHandler storage = ((TileEntityMachineReplicator)this.machine).getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null);
                    int matter = storage.getMatterStored();
                    storage.setMatterStored(matter - matterAmount);
                }
            } else if (((TileEntityMachineReplicator)this.machine).putInOutput(newItem)) {
                IMatterHandler storage = ((TileEntityMachineReplicator)this.machine).getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null);
                int matter = storage.getMatterStored();
                storage.setMatterStored(matter - matterAmount);
                MatterNetworkTaskReplicatePattern task = (MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek();
                task.setAmount(task.getAmount() - 1);
                if (task.getAmount() <= 0) {
                    task.setState(MatterNetworkTaskState.FINISHED);
                    this.getTaskQueue().dequeue();
                }
            }
        }
    }

    public int getEnergyDrainPerTick(ItemStack itemStack) {
        int maxEnergy = this.getEnergyDrainMax();
        return maxEnergy / this.getSpeed(itemStack);
    }

    public int getEnergyDrainPerTick() {
        if (this.getTaskQueue().peek() != null && ((MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek()).isValid(this.getWorld())) {
            return this.getEnergyDrainPerTick(((MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek()).getPattern().toItemStack(false));
        }
        return 0;
    }

    public int getEnergyDrainMax() {
        if (this.getTaskQueue().peek() != null && ((MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek()).isValid(this.getWorld())) {
            int matter = MatterHelper.getMatterAmountFromItem(((MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek()).getPattern().toItemStack(false));
            double upgradeMultiply = ((TileEntityMachineReplicator)this.machine).getUpgradeMultiply(UpgradeTypes.PowerUsage);
            return (int)Math.round(Math.log1p((double)matter * 0.05) * 4.0 * (double)REPLICATE_ENERGY_PER_MATTER * upgradeMultiply);
        }
        return 0;
    }

    public int getSpeed(ItemStack itemStack) {
        double matter = Math.log1p(MatterHelper.getMatterAmountFromItem(itemStack));
        matter *= matter;
        return (int)Math.round(((double)REPLICATE_SPEED_PER_MATTER * Math.log1p(matter * 0.05) * 10.0 - 60.0) * ((TileEntityMachineReplicator)this.machine).getUpgradeMultiply(UpgradeTypes.Speed)) + 60;
    }

    public double getFailChance(ItemPattern itemPattern) {
        double progressChance = 1.0f - itemPattern.getProgressF();
        double upgradeMultiply = ((TileEntityMachineReplicator)this.machine).getUpgradeMultiply(UpgradeTypes.Fail);
        return 0.005 * upgradeMultiply + progressChance * 0.5 + progressChance * 0.5 * upgradeMultiply;
    }

    public boolean isReplicating() {
        if (((TileEntityMachineReplicator)this.machine).getRedstoneActive() && this.getTaskQueue().size() > 0 && ((MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek()).isValid(this.getWorld())) {
            ItemStack item = ((MatterNetworkTaskReplicatePattern)this.getTaskQueue().peek()).getPattern().toItemStack(false);
            int matter = MatterHelper.getMatterAmountFromItem(item);
            return ((TileEntityMachineReplicator)this.machine).getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null).getMatterStored() >= matter && ((TileEntityMachineReplicator)this.machine).canReplicateIntoOutput(item) && ((TileEntityMachineReplicator)this.machine).canReplicateIntoSecoundOutput(matter);
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readFromNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.replicateTime = nbt.func_74765_d("ReplicateTime");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeToNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA) && toDisk) {
            nbt.func_74777_a("ReplicateTime", (short)this.replicateTime);
        }
    }

    public float getReplicateProgress() {
        return this.replicateProgress;
    }
}

