/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.matter_network.MatterNetworkRegistry;
import matteroverdrive.util.MOLog;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.logging.log4j.Level;

public class MatterNetworkTaskQueue<T extends MatterNetworkTask> {
    protected final List<T> elements;
    int capacity = 0;
    String name;

    public MatterNetworkTaskQueue(String name, int capacity) {
        this.name = name;
        this.elements = new ArrayList<T>(capacity);
        this.capacity = capacity;
    }

    public boolean queue(T element) {
        if (this.remaintingCapacity() > 0) {
            if (this.elements.size() > 0) {
                try {
                    this.elements.add(this.elements.size(), element);
                    return true;
                }
                catch (Exception e) {
                    MOLog.error("Could not add element to queue", e, new Object[0]);
                    return false;
                }
            }
            return this.elements.add(element);
        }
        return false;
    }

    public T dropAt(int i) {
        if (i < this.elements.size()) {
            return (T)((MatterNetworkTask)this.elements.remove(i));
        }
        return null;
    }

    public T dequeue() {
        if (this.elements.size() > 0) {
            return (T)((MatterNetworkTask)this.elements.remove(0));
        }
        return null;
    }

    public T peek() {
        if (this.elements.size() > 0) {
            return (T)((MatterNetworkTask)this.elements.get(0));
        }
        return null;
    }

    public int getLastIndex() {
        if (this.elements.size() > 0) {
            return this.elements.size() - 1;
        }
        return -1;
    }

    public T getAt(int i) {
        if (i >= 0 && i < this.elements.size()) {
            return (T)((MatterNetworkTask)this.elements.get(i));
        }
        return null;
    }

    public T dropWithID(long id) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (((MatterNetworkTask)this.elements.get(i)).getId() != id) continue;
            return (T)((MatterNetworkTask)this.elements.remove(i));
        }
        return null;
    }

    public T getWithID(long id) {
        for (MatterNetworkTask element : this.elements) {
            if (element.getId() != id) continue;
            return (T)element;
        }
        return null;
    }

    public void clear() {
        this.elements.clear();
    }

    public boolean remove(T task) {
        return this.elements.remove(task);
    }

    public int size() {
        return this.elements.size();
    }

    public int remaintingCapacity() {
        return this.capacity - this.elements.size();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        this.elements.clear();
        NBTTagList tagList = tagCompound.func_150295_c(this.name, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            try {
                MatterNetworkTask element = (MatterNetworkTask)this.getElementClassFromNBT(tagList.func_150305_b(i)).newInstance();
                this.readElementFromNBT(tagList.func_150305_b(i), element);
                this.elements.add(element);
                continue;
            }
            catch (InstantiationException e) {
                MOLog.log(Level.ERROR, e, "There was a problem while loading a packet of type %s", this.getElementClassFromNBT(tagList.func_150305_b(i)));
                continue;
            }
            catch (IllegalAccessException e) {
                MOLog.log(Level.ERROR, e, "There was a problem while loading a packet of type %s", this.getElementClassFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    public void readFromBuffer(ByteBuf byteBuf) {
        this.elements.clear();
        int elementsCount = byteBuf.readInt();
        for (int i = 0; i < elementsCount; ++i) {
            try {
                MatterNetworkTask element = (MatterNetworkTask)this.getElementClassFromBuffer(byteBuf).newInstance();
                this.readElementFromBuffer(byteBuf, element);
                this.elements.add(element);
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                MOLog.log(Level.ERROR, e, "There was a problem while loading a packet of type %s", this.getElementClassFromBuffer(byteBuf));
            }
        }
    }

    protected void readElementFromNBT(NBTTagCompound tagCompound, MatterNetworkTask element) {
        element.readFromNBT(tagCompound);
    }

    protected void writeElementToNBT(NBTTagCompound tagCompound, MatterNetworkTask element) {
        element.writeToNBT(tagCompound);
        tagCompound.func_74768_a("Type", MatterNetworkRegistry.getTaskID(element.getClass()));
    }

    protected void readElementFromBuffer(ByteBuf byteBuf, T element) {
        ((MatterNetworkTask)element).readFromNBT(ByteBufUtils.readTag((ByteBuf)byteBuf));
    }

    protected void writeElementToBuffer(ByteBuf byteBuf, T element) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        byteBuf.writeInt(MatterNetworkRegistry.getTaskID(element.getClass()));
        ((MatterNetworkTask)element).writeToNBT(tagCompound);
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)tagCompound);
    }

    protected Class getElementClassFromNBT(NBTTagCompound tagCompound) {
        return MatterNetworkRegistry.getTaskClass(tagCompound.func_74762_e("Type"));
    }

    protected Class getElementClassFromBuffer(ByteBuf byteBuf) {
        return MatterNetworkRegistry.getTaskClass(byteBuf.readInt());
    }

    public void drop() {
        for (MatterNetworkTask task : this.elements) {
            task.setState(MatterNetworkTaskState.INVALID);
        }
        this.elements.clear();
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList taskList = new NBTTagList();
        for (MatterNetworkTask element : this.elements) {
            NBTTagCompound taskNBT = new NBTTagCompound();
            this.writeElementToNBT(taskNBT, element);
            taskList.func_74742_a((NBTBase)taskNBT);
        }
        tagCompound.func_74782_a(this.name, (NBTBase)taskList);
    }

    public void writeToBuffer(ByteBuf byteBuf) {
        byteBuf.writeInt(this.elements.size());
        for (MatterNetworkTask element : this.elements) {
            this.writeElementToBuffer(byteBuf, element);
        }
        byteBuf.retain();
    }
}

