/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.container.matter_network.ITaskQueueWatcher;
import matteroverdrive.data.Inventory;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineComponentAbstract;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TaskQueueComponent<T extends MatterNetworkTask, M extends MOTileEntityMachine>
extends MachineComponentAbstract<M> {
    private final int queueId;
    private MatterNetworkTaskQueue<T> taskQueue;

    public TaskQueueComponent(String name, M machine, int taskQueueCapacity, int queueId) {
        super(machine);
        this.taskQueue = new MatterNetworkTaskQueue(name, taskQueueCapacity);
        this.queueId = queueId;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA) && nbt.func_74764_b("tasks")) {
            this.taskQueue.readFromNBT(nbt.func_74775_l("tasks"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (categories.contains((Object)MachineNBTCategory.DATA) && toDisk) {
            NBTTagCompound taskQueueTag = new NBTTagCompound();
            this.taskQueue.writeToNBT(taskQueueTag);
            nbt.func_74782_a("tasks", (NBTBase)taskQueueTag);
        }
    }

    @Override
    public void registerSlots(Inventory inventory) {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void onMachineEvent(MachineEvent event) {
    }

    public void sendTaskQueueAddedToWatchers(long taskId) {
        this.machine.getWatchers().stream().filter(watcher -> watcher instanceof ITaskQueueWatcher).forEach(watcher -> ((ITaskQueueWatcher)watcher).onTaskAdded((IMatterNetworkDispatcher)((Object)this.machine), taskId, this.queueId));
    }

    public void sendTaskQueueRemovedFromWatchers(long taskId) {
        this.machine.getWatchers().stream().filter(watcher -> watcher instanceof ITaskQueueWatcher).forEach(watcher -> ((ITaskQueueWatcher)watcher).onTaskRemoved((IMatterNetworkDispatcher)((Object)this.machine), taskId, this.queueId));
    }

    public MatterNetworkTaskQueue<T> getTaskQueue() {
        return this.taskQueue;
    }

    public int getQueueId() {
        return this.queueId;
    }
}

