/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server.task_queue;

import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.client.task_queue.PacketSyncTaskQueue;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRemoveTask
extends TileEntityUpdatePacket {
    int taskIndex;
    byte queueID;
    MatterNetworkTaskState task_state;

    public PacketRemoveTask() {
    }

    public PacketRemoveTask(TileEntity dispatcher, int taskIndex, byte queueID, MatterNetworkTaskState task_state) {
        super(dispatcher);
        this.taskIndex = taskIndex;
        this.queueID = queueID;
        this.task_state = task_state;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.taskIndex = buf.readInt();
        this.queueID = buf.readByte();
        this.task_state = MatterNetworkTaskState.get(buf.readByte());
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.taskIndex);
        buf.writeByte((int)this.queueID);
        buf.writeByte(this.task_state.ordinal());
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketRemoveTask> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketRemoveTask message, MessageContext ctx) {
            TileEntity entity = message.getTileEntity(player.field_70170_p);
            if (entity instanceof IMatterNetworkDispatcher) {
                IMatterNetworkDispatcher dispatcher = (IMatterNetworkDispatcher)entity;
                ((MatterNetworkTask)dispatcher.getTaskQueue(message.queueID).dropAt(message.taskIndex)).setState(message.task_state);
                MatterOverdrive.NETWORK.sendTo(new PacketSyncTaskQueue(dispatcher, message.queueID), player);
            }
        }
    }
}

