/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap.data;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.starmap.GalaxyGenerator;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class Quadrant
extends SpaceBody {
    private Galaxy galaxy;
    private HashMap<Integer, Star> starHashMap;
    private boolean loaded;
    private float size;
    private float x;
    private float y;
    private float z;
    private boolean isDirty;

    public Quadrant() {
        this.init();
    }

    public Quadrant(String name, int id) {
        super(name, id);
        this.init();
    }

    public void update(World world) {
        for (Star star : this.getStars()) {
            star.update(world);
        }
    }

    public void generateMissing(NBTTagCompound tagCompound, GalaxyGenerator galaxyGenerator) {
        for (Star star : this.getStars()) {
            star.generateMissing(tagCompound, galaxyGenerator);
        }
    }

    public void onSave(File file, World world) {
        this.isDirty = false;
        for (Star star : this.getStars()) {
            star.onSave(file, world);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        NBTTagList starList = new NBTTagList();
        tagCompound.func_74776_a("X", this.x);
        tagCompound.func_74776_a("Y", this.y);
        tagCompound.func_74776_a("Z", this.z);
        tagCompound.func_74776_a("Size", this.size);
        for (Star star : this.getStars()) {
            NBTTagCompound quadrantNBT = new NBTTagCompound();
            star.writeToNBT(quadrantNBT);
            starList.func_74742_a((NBTBase)quadrantNBT);
        }
        tagCompound.func_74782_a("Stars", (NBTBase)starList);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeFloat(this.size);
        buf.writeInt(this.getStars().size());
        for (Star star : this.getStars()) {
            star.writeToBuffer(buf);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound, GalaxyGenerator generator) {
        super.readFromNBT(tagCompound, generator);
        if (tagCompound != null) {
            this.x = tagCompound.func_74760_g("X");
            this.y = tagCompound.func_74760_g("Y");
            this.z = tagCompound.func_74760_g("Z");
            this.size = tagCompound.func_74760_g("Size");
            NBTTagList starList = tagCompound.func_150295_c("Stars", 10);
            for (int i = 0; i < starList.func_74745_c(); ++i) {
                Star star = new Star();
                star.readFromNBT(starList.func_150305_b(i), generator);
                this.addStar(star);
                star.setQuadrant(this);
            }
        }
    }

    @Override
    public void readFromBuffer(ByteBuf buf) {
        super.readFromBuffer(buf);
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        this.size = buf.readFloat();
        int starCount = buf.readInt();
        for (int i = 0; i < starCount; ++i) {
            Star star = new Star();
            star.readFromBuffer(buf);
            this.addStar(star);
            star.setQuadrant(this);
        }
    }

    @Override
    public SpaceBody getParent() {
        return this.galaxy;
    }

    private void init() {
        this.starHashMap = new HashMap();
    }

    public Star star(int at) {
        return this.starHashMap.get(at);
    }

    public boolean hasStar(int id) {
        return this.starHashMap.containsKey(id);
    }

    private boolean isLoaded() {
        return this.loaded;
    }

    public Collection<Star> getStars() {
        return this.starHashMap.values();
    }

    public Map<Integer, Star> getStarMap() {
        return this.starHashMap;
    }

    public void addStar(Star star) {
        this.starHashMap.put(star.getId(), star);
    }

    public Galaxy getGalaxy() {
        return this.galaxy;
    }

    public void setGalaxy(Galaxy galaxy) {
        this.galaxy = galaxy;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        for (Star star : this.getStars()) {
            if (!star.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

