/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.MachineMatterStorage;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.client.PacketMatterUpdate;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class MOTileEntityMachineMatter
extends MOTileEntityMachineEnergy {
    protected MachineMatterStorage matterStorage = new MachineMatterStorage<MOTileEntityMachineMatter>(this, 32768);

    public MOTileEntityMachineMatter(int upgradesCount) {
        super(upgradesCount);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA) && this.matterStorage != null) {
            this.matterStorage.writeToNBT(nbt);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA) && this.matterStorage != null) {
            this.matterStorage.readFromNBT(nbt);
        }
    }

    public void updateClientMatter() {
        if (this.field_145850_b != null) {
            MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketMatterUpdate(this), this, 64.0);
        }
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        super.readFromPlaceItem(itemStack);
        if (itemStack != null && this.matterStorage != null && itemStack.func_77942_o()) {
            this.matterStorage.readFromNBT(itemStack.func_77978_p());
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        super.writeToDropItem(itemStack);
        if (itemStack != null && this.matterStorage != null && this.matterStorage.getMatterStored() > 0) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.matterStorage.writeToNBT(itemStack.func_77978_p());
            itemStack.func_77978_p().func_74768_a("MaxMatter", this.matterStorage.getCapacity());
            itemStack.func_77978_p().func_74768_a("MatterSend", this.matterStorage.getMaxExtract());
            itemStack.func_77978_p().func_74768_a("MatterReceive", this.matterStorage.getMaxReceive());
        }
    }

    public MachineMatterStorage getMatterStorage() {
        return this.matterStorage;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == MatterOverdriveCapabilities.MATTER_HANDLER || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == MatterOverdriveCapabilities.MATTER_HANDLER || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.matterStorage;
        }
        return super.getCapability(capability, facing);
    }
}

