/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.events.anomaly.MOEventGravitationalAnomalyConsume;
import matteroverdrive.api.gravity.AnomalySuppressor;
import matteroverdrive.api.gravity.IGravitationalAnomaly;
import matteroverdrive.api.gravity.IGravityEntity;
import matteroverdrive.client.sound.GravitationalAnomalySound;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.fx.GravitationalAnomalyParticle;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.items.SpacetimeEqualizer;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.IMOTickable;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.TimeTracker;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityGravitationalAnomaly
extends MOTileEntity
implements IScannable,
IMOTickable,
IGravitationalAnomaly,
ITickable {
    public static final float MAX_VOLUME = 0.5f;
    public static final int BLOCK_DESTORY_DELAY = 6;
    public static final int MAX_BLOCKS_PER_HARVEST = 6;
    public static final int MAX_LIQUIDS_PER_HARVEST = 32;
    public static final double STREHGTH_MULTIPLYER = 1.0E-5;
    public static final double G = 6.67384;
    public static final double G2 = 13.34768;
    public static final double C = 2.99792458;
    public static final double CC = 8.987551787368176;
    public static boolean FALLING_BLOCKS = true;
    public static boolean BLOCK_ENTETIES = true;
    public static boolean VANILLA_FLUIDS = true;
    public static boolean FORGE_FLUIDS = true;
    public static boolean BLOCK_DESTRUCTION = true;
    public static boolean GRAVITATION = true;
    private final TimeTracker blockDestoryTimer = new TimeTracker();
    PriorityQueue<BlockPos> blocks;
    List<AnomalySuppressor> supressors;
    @SideOnly(value=Side.CLIENT)
    private GravitationalAnomalySound sound;
    private long mass;
    private float suppression;

    public TileEntityGravitationalAnomaly() {
        this(2048L + Math.round(Math.random() * 8192.0));
    }

    public TileEntityGravitationalAnomaly(long mass) {
        this.mass = mass;
        this.supressors = new ArrayList<AnomalySuppressor>();
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles(this.field_145850_b);
            this.manageSound();
            this.manageClientEntityGravitation(this.field_145850_b);
        }
    }

    public void setMass(long mass) {
        this.mass = mass;
    }

    @Override
    public void onServerTick(TickEvent.Phase phase, World world) {
        if (world == null) {
            return;
        }
        if (phase.equals((Object)TickEvent.Phase.END)) {
            float tmpSuppression = this.calculateSuppression();
            if (tmpSuppression != this.suppression) {
                this.suppression = tmpSuppression;
            }
            this.manageEntityGravitation(world, 0.0f);
            this.manageBlockDestory(world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world) {
        double radius = (float)this.getBlockBreakRange();
        Vector3f point = MOMathHelper.randomSpherePoint((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, new Vec3d(radius, radius, radius), world.field_73012_v);
        GravitationalAnomalyParticle particle = new GravitationalAnomalyParticle(world, point.x, point.y, point.z, new Vec3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f)));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @SideOnly(value=Side.CLIENT)
    public void manageClientEntityGravitation(World world) {
        if (!GRAVITATION) {
            return;
        }
        double rangeSq = this.getMaxRange() + 1.0;
        rangeSq *= rangeSq;
        Vec3d blockPos = new Vec3d((Vec3i)this.func_174877_v());
        blockPos.func_72441_c(0.5, 0.5, 0.5);
        Vec3d entityPos = Minecraft.func_71410_x().field_71439_g.func_174791_d();
        double distanceSq = entityPos.func_72436_e(blockPos);
        if (distanceSq < rangeSq) {
            if (!Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(2).func_190926_b() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(2).func_77973_b() instanceof SpacetimeEqualizer || Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || Minecraft.func_71410_x().field_71439_g.func_175149_v() || MOPlayerCapabilityProvider.GetAndroidCapability((Entity)Minecraft.func_71410_x().field_71439_g).isUnlocked(OverdriveBioticStats.equalizer, 0)) {
                return;
            }
            double acceleration = this.getAcceleration(distanceSq);
            Vec3d dir = blockPos.func_178788_d(entityPos).func_72432_b();
            Minecraft.func_71410_x().field_71439_g.func_70024_g(dir.field_72450_a * acceleration, dir.field_72448_b * acceleration, dir.field_72449_c * acceleration);
            Minecraft.func_71410_x().field_71439_g.field_70133_I = true;
        }
    }

    public void manageEntityGravitation(World world, float ticks) {
        if (!GRAVITATION) {
            return;
        }
        double range = this.getMaxRange() + 1.0;
        AxisAlignedBB bb = new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - range, (double)this.func_174877_v().func_177956_o() - range, (double)this.func_174877_v().func_177952_p() - range, (double)this.func_174877_v().func_177958_n() + range, (double)this.func_174877_v().func_177956_o() + range, (double)this.func_174877_v().func_177952_p() + range);
        List entities = world.func_72872_a(Entity.class, bb);
        Vec3d blockPos = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
        for (Object entityObject : entities) {
            Entity entity;
            if (!(entityObject instanceof Entity) || (entity = (Entity)entityObject) instanceof IGravityEntity && !((IGravityEntity)entity).isAffectedByAnomaly(this)) continue;
            Vec3d entityPos = entity.func_174791_d();
            double distanceSq = entityPos.func_72436_e(blockPos);
            double acceleration = this.getAcceleration(distanceSq);
            double eventHorizon = this.getEventHorizon();
            Vec3d dir = blockPos.func_178788_d(entityPos).func_72432_b();
            dir = new Vec3d(dir.field_72450_a * acceleration, dir.field_72448_b * acceleration, dir.field_72449_c * acceleration);
            if (this.intersectsAnomaly(entityPos, dir, blockPos, eventHorizon)) {
                this.consume(entity);
            }
            if (entityObject instanceof EntityPlayer) continue;
            if (entityObject instanceof EntityLivingBase) {
                AtomicBoolean se = new AtomicBoolean(false);
                ((EntityLivingBase)entityObject).func_184193_aE().forEach(i -> {
                    if (!i.func_190926_b() && i.func_77973_b() instanceof SpacetimeEqualizer) {
                        se.set(true);
                    }
                });
                if (se.get()) continue;
            }
            entity.func_70024_g(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        }
    }

    boolean intersectsAnomaly(Vec3d origin, Vec3d dir, Vec3d anomaly, double radius) {
        double v;
        if (origin.func_72438_d(anomaly) <= radius) {
            return true;
        }
        Vec3d intersectDir = origin.func_178788_d(anomaly);
        double c = intersectDir.func_72433_c();
        double d = radius * radius - (c * c - (v = intersectDir.func_72430_b(dir)) * v);
        return d >= 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void stopSounds() {
        if (this.sound != null) {
            this.sound.stopPlaying();
            FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.sound);
            this.sound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSounds() {
        if (this.sound == null) {
            this.sound = new GravitationalAnomalySound(MatterOverdriveSounds.windy, SoundCategory.BLOCKS, this.func_174877_v(), 0.2f, this.getMaxRange());
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        } else if (!FMLClientHandler.instance().getClient().func_147118_V().func_147692_c((ISound)this.sound)) {
            this.stopSounds();
            this.sound = new GravitationalAnomalySound(MatterOverdriveSounds.windy, SoundCategory.BLOCKS, this.func_174877_v(), 0.2f, this.getMaxRange());
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void manageSound() {
        if (this.sound == null) {
            this.playSounds();
        } else {
            this.sound.setVolume(Math.min(0.5f, this.getBreakStrength(0.0f, (float)this.getMaxRange()) * 0.1f));
            this.sound.setRange(this.getMaxRange());
        }
    }

    @Override
    public void onAdded(World world, BlockPos pos, IBlockState state) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed(World worldIn, BlockPos pos, IBlockState state) {
    }

    @Override
    public void onNeighborBlockChange(IBlockAccess world, BlockPos pos, IBlockState state, Block neighborBlock) {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    @Override
    public void onScan(World world, double x, double y, double z, EntityPlayer player, ItemStack scanner) {
    }

    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K) {
            this.stopSounds();
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeCustomNBT(syncData, MachineNBTCategory.ALL_OPTS, false);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound syncData = pkt.func_148857_g();
        if (syncData != null) {
            this.readCustomNBT(syncData, MachineNBTCategory.ALL_OPTS);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopSounds();
        }
    }

    private boolean onEntityConsume(Entity entity, boolean pre) {
        if (entity instanceof IGravityEntity) {
            ((IGravityEntity)entity).onEntityConsumed(this);
        }
        if (pre) {
            MinecraftForge.EVENT_BUS.post((Event)new MOEventGravitationalAnomalyConsume.Pre(entity, this.func_174877_v()));
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new MOEventGravitationalAnomalyConsume.Post(entity, this.func_174877_v()));
        }
        return true;
    }

    public void manageBlockDestory(World world) {
        double distance;
        IBlockState blockState;
        if (!BLOCK_DESTRUCTION) {
            return;
        }
        int solidCount = 0;
        int liquidCount = 0;
        int range = (int)Math.floor(this.getBlockBreakRange());
        double eventHorizon = this.getEventHorizon();
        this.blocks = new PriorityQueue<BlockPos>(1, new BlockComparitor(this.func_174877_v()));
        if (this.blockDestoryTimer.hasDelayPassed(world, 6)) {
            for (int x = -range; x < range; ++x) {
                for (int y = -range; y < range; ++y) {
                    for (int z = -range; z < range; ++z) {
                        BlockPos blockPos = new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o() + y, this.func_174877_v().func_177952_p() + z);
                        blockState = world.func_180495_p(blockPos);
                        distance = Math.sqrt(blockPos.func_177951_i((Vec3i)this.func_174877_v()));
                        float hardness = blockState.func_185887_b(world, blockPos);
                        if (blockState.func_177230_c() instanceof IFluidBlock || blockState.func_177230_c() instanceof BlockLiquid) {
                            hardness = 1.0f;
                        }
                        float strength = this.getBreakStrength((float)distance, range);
                        if (blockState == null || blockState.func_177230_c() == null || blockState.func_177230_c() == Blocks.field_150350_a || !(distance <= (double)range) || !(hardness >= 0.0f) || !(distance < eventHorizon) && !(hardness < strength)) continue;
                        this.blocks.add(blockPos);
                    }
                }
            }
        }
        for (BlockPos position : this.blocks) {
            blockState = world.func_180495_p(position);
            if (this.cleanFlowingLiquids(blockState, position)) continue;
            if (liquidCount < 32 && this.cleanLiquids(blockState, position)) {
                ++liquidCount;
                continue;
            }
            if (solidCount >= 6) continue;
            try {
                distance = Math.sqrt(position.func_177951_i((Vec3i)this.func_174877_v()));
                float strength = this.getBreakStrength((float)distance, range);
                if (!this.breakBlock(world, position, strength, eventHorizon, range)) continue;
                ++solidCount;
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while trying to brake block %s", blockState.func_177230_c());
            }
        }
    }

    public void consume(Entity entity) {
        if (!entity.field_70128_L && this.onEntityConsume(entity, true)) {
            boolean consumedFlag = false;
            if (entity instanceof EntityItem) {
                consumedFlag |= this.consumeEntityItem((EntityItem)entity);
            } else if (entity instanceof EntityFallingBlock) {
                consumedFlag |= this.consumeFallingBlock((EntityFallingBlock)entity);
            } else if (entity instanceof EntityLivingBase) {
                consumedFlag |= this.consumeLivingEntity((EntityLivingBase)entity, this.getBreakStrength((float)entity.func_70011_f((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), (float)this.getMaxRange()));
            }
            if (consumedFlag) {
                this.onEntityConsume(entity, false);
            }
        }
    }

    private boolean consumeEntityItem(EntityItem entityItem) {
        ItemStack itemStack = entityItem.func_92059_d();
        if (!itemStack.func_190926_b()) {
            try {
                this.mass = Math.addExact(this.mass, (long)MatterHelper.getMatterAmountFromItem(itemStack) * (long)itemStack.func_190916_E());
                this.func_70296_d();
            }
            catch (ArithmeticException e) {
                return false;
            }
            entityItem.func_70106_y();
            this.field_145850_b.func_72900_e((Entity)entityItem);
            if (entityItem.func_92059_d().func_77973_b() == Items.field_151156_bN) {
                this.collapse();
            }
            if (entityItem.func_92059_d().func_77973_b().getRegistryName().toString().equalsIgnoreCase("extendedcrafting:storage") && entityItem.func_92059_d().func_77960_j() == 2) {
                this.collapse();
            } else if (entityItem.func_92059_d().func_77973_b().func_77653_i(entityItem.func_92059_d()).toLowerCase().contains("nether star")) {
                this.collapse();
            }
            return true;
        }
        return false;
    }

    private boolean consumeFallingBlock(EntityFallingBlock fallingBlock) {
        ItemStack itemStack = new ItemStack(fallingBlock.func_175131_l().func_177230_c(), 1, fallingBlock.func_175131_l().func_177230_c().func_180651_a(fallingBlock.func_175131_l()));
        if (!itemStack.func_190926_b()) {
            try {
                this.mass = Math.addExact(this.mass, (long)MatterHelper.getMatterAmountFromItem(itemStack) * (long)itemStack.func_190916_E());
                this.func_70296_d();
            }
            catch (ArithmeticException e) {
                return false;
            }
            fallingBlock.func_70106_y();
            this.field_145850_b.func_72900_e((Entity)fallingBlock);
            return true;
        }
        return false;
    }

    private boolean consumeLivingEntity(EntityLivingBase entity, float strength) {
        try {
            this.mass = Math.addExact(this.mass, (long)Math.min(entity.func_110143_aJ(), strength));
            this.func_70296_d();
        }
        catch (ArithmeticException e) {
            return false;
        }
        if (entity.func_110143_aJ() <= strength && !(entity instanceof EntityPlayer)) {
            entity.func_70106_y();
            this.field_145850_b.func_72900_e((Entity)entity);
        }
        DamageSource damageSource = new DamageSource("blackHole");
        entity.func_70097_a(damageSource, strength);
        return true;
    }

    public boolean breakBlock(World world, BlockPos pos, float strength, double eventHorizon, int range) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pos)) {
            return true;
        }
        float hardness = blockState.func_185887_b(world, pos);
        double distance = Math.sqrt(pos.func_177951_i((Vec3i)this.func_174877_v()));
        if (distance <= (double)range && hardness >= 0.0f && (distance < eventHorizon || hardness < strength)) {
            if (BLOCK_ENTETIES) {
                if (FALLING_BLOCKS) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, blockState);
                    fallingBlock.field_145812_b = 5;
                    fallingBlock.field_70145_X = true;
                    world.func_72838_d((Entity)fallingBlock);
                } else {
                    ItemStack bStack = blockState.func_177230_c().getPickBlock(blockState, null, world, pos, null);
                    if (!bStack.func_190926_b()) {
                        EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, bStack);
                        world.func_72838_d((Entity)item);
                    }
                }
                blockState.func_177230_c().func_180663_b(world, pos, blockState);
                world.func_175669_a(2001, pos, Block.func_149682_b((Block)blockState.func_177230_c()));
                world.func_175698_g(pos);
                return true;
            }
            int matter = 0;
            if (blockState.func_177230_c().canSilkHarvest(world, pos, blockState, null)) {
                matter += MatterHelper.getMatterAmountFromItem(blockState.func_177230_c().getPickBlock(blockState, null, world, pos, null));
            } else {
                for (Object stack : blockState.func_177230_c().getDrops((IBlockAccess)world, pos, blockState, 0)) {
                    matter += MatterHelper.getMatterAmountFromItem((ItemStack)stack);
                }
            }
            world.func_175669_a(2001, pos, Block.func_149682_b((Block)blockState.func_177230_c()));
            List result = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 3), (double)(pos.func_177956_o() + 3), (double)(pos.func_177952_p() + 3)));
            for (EntityItem entityItem : result) {
                this.consumeEntityItem(entityItem);
            }
            try {
                this.mass = Math.addExact(this.mass, (long)matter);
                this.func_70296_d();
            }
            catch (ArithmeticException e) {
                return false;
            }
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public boolean cleanLiquids(IBlockState blockState, BlockPos pos) {
        if (blockState.func_177230_c() instanceof IFluidBlock && FORGE_FLUIDS) {
            if (((IFluidBlock)blockState.func_177230_c()).canDrain(this.field_145850_b, pos)) {
                if (FALLING_BLOCKS) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, blockState);
                    fallingBlock.field_70145_X = true;
                    this.field_145850_b.func_72838_d((Entity)fallingBlock);
                }
                ((IFluidBlock)blockState.func_177230_c()).drain(this.field_145850_b, pos, true);
                return true;
            }
        } else if (blockState.func_177230_c() instanceof BlockLiquid && VANILLA_FLUIDS) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2)) {
                if (FALLING_BLOCKS) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, state);
                    fallingBlock.field_70145_X = true;
                    this.field_145850_b.func_72838_d((Entity)fallingBlock);
                }
                return true;
            }
        }
        return false;
    }

    public boolean cleanFlowingLiquids(IBlockState block, BlockPos pos) {
        if (VANILLA_FLUIDS && (block == Blocks.field_150358_i || block == Blocks.field_150356_k)) {
            return this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        return false;
    }

    @Override
    public void collapse() {
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.field_145850_b.func_72876_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (float)this.getRealMassUnsuppressed(), true);
    }

    @Override
    public void addInfo(World world, double x, double y, double z, List<String> infos) {
        DecimalFormat format = new DecimalFormat("#.##");
        infos.add("Mass: " + this.mass);
        infos.add("Range: " + format.format(this.getMaxRange()));
        infos.add("Brake Range: " + format.format(this.getBlockBreakRange()));
        infos.add("Horizon: " + format.format(this.getEventHorizon()));
        infos.add("Brake Lvl: " + format.format(this.getBreakStrength()));
    }

    @Override
    public void suppress(AnomalySuppressor suppressor) {
        for (AnomalySuppressor s : this.supressors) {
            if (!s.update(suppressor)) continue;
            return;
        }
        this.supressors.add(suppressor);
    }

    private float calculateSuppression() {
        float suppression = 1.0f;
        Iterator<AnomalySuppressor> iterator = this.supressors.iterator();
        while (iterator.hasNext()) {
            AnomalySuppressor s = iterator.next();
            if (!s.isValid()) {
                iterator.remove();
            }
            s.tick();
            suppression *= s.getAmount();
        }
        return suppression;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74772_a("Mass", this.mass);
            nbt.func_74776_a("Suppression", this.suppression);
            if (toDisk && this.supressors != null && this.supressors.size() > 0) {
                NBTTagList suppressors = new NBTTagList();
                for (AnomalySuppressor s : this.supressors) {
                    NBTTagCompound suppressorTag = new NBTTagCompound();
                    s.writeToNBT(suppressorTag);
                    suppressors.func_74742_a((NBTBase)suppressorTag);
                }
                nbt.func_74782_a("suppressors", (NBTBase)suppressors);
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.supressors.clear();
            this.mass = nbt.func_74763_f("Mass");
            this.suppression = nbt.func_74760_g("Suppression");
            NBTTagList suppressors = nbt.func_150295_c("suppressors", 10);
            for (int i = 0; i < this.supressors.size(); ++i) {
                NBTTagCompound suppressorTag = suppressors.func_150305_b(i);
                AnomalySuppressor s = new AnomalySuppressor(suppressorTag);
                this.supressors.add(s);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.max(Math.pow(this.getMaxRange(), 3.0), 2048.0);
    }

    public Block getBlock(World world, BlockPos blockPos) {
        return world.func_180495_p(blockPos).func_177230_c();
    }

    @Override
    public double getEventHorizon() {
        return Math.max(13.34768 * this.getRealMass() / 8.987551787368176, 0.5);
    }

    @Override
    public double getBlockBreakRange() {
        return this.getMaxRange() / 2.0;
    }

    @Override
    public double getMaxRange() {
        return Math.sqrt(this.getRealMass() * 667.384);
    }

    @Override
    public double getAcceleration(double distanceSq) {
        return 6.67384 * (this.getRealMass() / Math.max(distanceSq, (double)1.0E-4f));
    }

    @Override
    public double getRealMass() {
        return this.getRealMassUnsuppressed() * (double)this.suppression;
    }

    @Override
    public double getRealMassUnsuppressed() {
        return Math.log1p((double)Math.max(this.mass, 0L) * 1.0E-5);
    }

    @Override
    public float getBreakStrength(float distance, float maxRange) {
        return (float)this.getRealMass() * 4.0f * this.suppression * this.getDistanceFalloff(distance, maxRange);
    }

    @Override
    public float getDistanceFalloff(float distance, float maxRange) {
        return 1.0f - distance / maxRange;
    }

    @Override
    @Deprecated
    public float getBreakStrength() {
        return (float)this.getRealMass() * 4.0f * this.suppression;
    }

    public static class BlockComparitor
    implements Comparator<BlockPos> {
        private final BlockPos pos;

        public BlockComparitor(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            return Double.compare(o1.func_177954_c((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()), o2.func_177954_c((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()));
        }
    }
}

