/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.machines.IUpgradeHandler;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.tile.IMultiBlockTileEntity;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineChargingStation
extends MOTileEntityMachineEnergy
implements IMultiBlockTileEntity {
    public static final int ENERGY_CAPACITY = 512000;
    public static final int ENERGY_TRANSFER = 512;
    private static final UpgradeHandler upgradeHandler = new UpgradeHandler();
    public static int BASE_MAX_RANGE = 8;

    public TileEntityMachineChargingStation() {
        super(2);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxExtract(512);
        this.energyStorage.setMaxReceive(512);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.manageAndroidCharging();
    }

    private void manageAndroidCharging() {
        if (!this.field_145850_b.field_72995_K && this.getEnergyStorage().getEnergyStored() > 0) {
            int range = this.getRage();
            AxisAlignedBB radius = new AxisAlignedBB(this.func_174877_v().func_177982_a(-range, -range, -range), this.func_174877_v().func_177982_a(range, range, range));
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, radius);
            for (EntityPlayer player : players) {
                if (!MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player).isAndroid()) continue;
                int required = this.getRequiredEnergy(player, range);
                int max = Math.min(this.getEnergyStorage().getEnergyStored(), this.getMaxCharging());
                int toExtract = Math.min(required, max);
                this.getEnergyStorage().extractEnergy(MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player).receiveEnergy(toExtract, false), false);
            }
        }
    }

    public int getRage() {
        return (int)((double)BASE_MAX_RANGE * this.getUpgradeMultiply(UpgradeTypes.Range));
    }

    public int getMaxCharging() {
        return (int)(512.0 / this.getUpgradeMultiply(UpgradeTypes.PowerUsage));
    }

    private int getRequiredEnergy(EntityPlayer player, int maxRange) {
        return (int)(512.0 * (1.0 - MathHelper.func_151237_a((double)(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v).func_178788_d(new Vec3d((Vec3i)this.func_174877_v())).func_72433_c() / (double)maxRange), (double)0.0, (double)1.0)));
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type.equals((Object)UpgradeTypes.Range) || type.equals((Object)UpgradeTypes.PowerStorage) || type.equals((Object)UpgradeTypes.PowerUsage);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 8192.0;
    }

    @Override
    public List<BlockPos> getBoundingBlocks() {
        ArrayList<BlockPos> s = new ArrayList<BlockPos>();
        s.add(this.func_174877_v().func_177982_a(0, 1, 0));
        s.add(this.func_174877_v().func_177982_a(0, 2, 0));
        return s;
    }

    @Override
    public IUpgradeHandler getUpgradeHandler() {
        return upgradeHandler;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public static class UpgradeHandler
    implements IUpgradeHandler {
        @Override
        public double affectUpgrade(UpgradeTypes type, double multiply) {
            if (type.equals((Object)UpgradeTypes.Range)) {
                return Math.min(8.0, multiply);
            }
            return multiply;
        }
    }
}

