/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.data.transport.MatterNetwork;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityNetworkPipe
extends TileEntityPipe
implements IMatterNetworkConnection {
    private MatterNetwork matterNetwork;

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.manageNetwork();
        }
    }

    public void manageNetwork() {
        if (this.matterNetwork == null && !this.tryConnectToNeighborNetworks(this.field_145850_b)) {
            MatterNetwork network = (MatterNetwork)MatterOverdrive.MATTER_NETWORK_HANDLER.getNetwork(this);
            network.addNode(this);
        }
    }

    public boolean tryConnectToNeighborNetworks(World world) {
        boolean hasConnected = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity neighborEntity;
            BlockPos neighborPos = this.field_174879_c.func_177972_a(side);
            if (!world.func_175667_e(neighborPos) || !((neighborEntity = world.func_175625_s(neighborPos)) instanceof IMatterNetworkConnection) || !this.isConnectableSide(side) || ((IMatterNetworkConnection)neighborEntity).getNetwork() == null || ((IMatterNetworkConnection)neighborEntity).getNetwork() == this.matterNetwork) continue;
            ((MatterNetwork)((IMatterNetworkConnection)neighborEntity).getNetwork()).addNode(this);
            hasConnected = true;
        }
        return hasConnected;
    }

    @Override
    public boolean canConnectToNetworkNode(IBlockState blockState, IGridNode toNode, EnumFacing direction) {
        return this.isConnectableSide(direction);
    }

    @Override
    public boolean canConnectToPipe(TileEntity entity, EnumFacing direction) {
        return this.isConnectableSide(direction);
    }

    @Override
    public void onAdded(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            int connectionCount = 0;
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                BlockPos neighborPos = pos.func_177972_a(enumFacing);
                TileEntity tileEntityNeignbor = world.func_175625_s(neighborPos);
                IBlockState neighborState = world.func_180495_p(neighborPos);
                if (!(tileEntityNeignbor instanceof IMatterNetworkConnection) || connectionCount >= 2 || !((IMatterNetworkConnection)tileEntityNeignbor).establishConnectionFromSide(neighborState, enumFacing.func_176734_d())) continue;
                this.setConnection(enumFacing, true);
                world.func_175704_b(pos, pos);
                ++connectionCount;
            }
        }
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (this.matterNetwork != null) {
                this.matterNetwork.onNodeDestroy(state, this);
            }
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                TileEntity tileEntityConnection;
                if (!this.isConnectableSide(enumFacing) || !((tileEntityConnection = worldIn.func_175625_s(pos.func_177972_a(enumFacing))) instanceof IMatterNetworkConnection)) continue;
                ((IMatterNetworkConnection)tileEntityConnection).breakConnection(state, enumFacing.func_176734_d());
            }
        }
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (this.matterNetwork != null) {
                this.matterNetwork.onNodeDestroy(blockState, this);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(IBlockAccess world, BlockPos pos, IBlockState state, Block neighborBlock) {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    @Override
    public boolean canConnectFromSide(IBlockState blockState, EnumFacing side) {
        return MOMathHelper.getBoolean(this.getConnectionsMask(), side.ordinal());
    }

    @Override
    public BlockPos getNodePos() {
        return this.func_174877_v();
    }

    @Override
    public World getNodeWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean establishConnectionFromSide(IBlockState blockState, EnumFacing side) {
        int connCount = this.getConnectionsCount();
        if (connCount < 2 && !MOMathHelper.getBoolean(this.getConnectionsMask(), side.ordinal())) {
            this.setConnection(side, true);
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            return true;
        }
        return false;
    }

    @Override
    public void breakConnection(IBlockState blockState, EnumFacing side) {
        this.setConnection(side, false);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Override
    public void updateSides(boolean notify) {
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public MatterNetwork getNetwork() {
        return this.matterNetwork;
    }

    @Override
    public void setNetwork(MatterNetwork network) {
        this.matterNetwork = network;
    }
}

