/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import matteroverdrive.util.StackUtils;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class MOInventoryHelper {
    public static void setInventorySlotContents(@Nonnull ItemStack container, int slot, @Nonnull ItemStack stack) {
        if (StackUtils.isNullOrEmpty(stack)) {
            if (!container.func_77942_o()) {
                container.func_77982_d(new NBTTagCompound());
            }
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)new NBTTagCompound());
        } else {
            NBTTagCompound itemTag = new NBTTagCompound();
            stack.func_77955_b(itemTag);
            if (!container.func_77942_o()) {
                container.func_77982_d(new NBTTagCompound());
            }
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)itemTag);
        }
    }

    @Nonnull
    public static ItemStack decrStackSize(ItemStack container, int slot, int amount) {
        if (container.func_77978_p().func_74775_l("Slot" + slot).func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(container.func_77978_p().func_74775_l("Slot" + slot));
        ItemStack retStack = stack.func_77979_a(amount);
        if (stack.func_190916_E() <= 0) {
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)new NBTTagCompound());
        } else {
            NBTTagCompound itemTag = new NBTTagCompound();
            stack.func_77955_b(itemTag);
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)itemTag);
        }
        return retStack;
    }

    @Nonnull
    public static ItemStack getStackInSlot(ItemStack container, int slot) {
        if (!container.func_77942_o() || container.func_77978_p().func_74775_l("Slot" + slot).func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(container.func_77978_p().func_74775_l("Slot" + slot));
    }

    public static List<ItemStack> getStacks(ItemStack container) {
        if (!container.func_77942_o()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (String s : container.func_77978_p().func_150296_c()) {
            ItemStack stack;
            NBTBase nbtbase;
            if (!s.startsWith("Slot") || !((nbtbase = container.func_77978_p().func_74781_a(s)) instanceof NBTTagCompound) || StackUtils.isNullOrEmpty(stack = new ItemStack((NBTTagCompound)nbtbase))) continue;
            itemStacks.add(stack);
        }
        return itemStacks;
    }

    public static ItemStack addItemInContainer(Container container, ItemStack itemStack) {
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            if (!container.func_75139_a(i).func_75214_a(itemStack)) continue;
            if (StackUtils.isNullOrEmpty(container.func_75139_a(i).func_75211_c())) {
                container.func_75139_a(i).func_75215_d(itemStack);
                if (itemStack.func_190916_E() > itemStack.func_77976_d()) {
                    itemStack.func_190920_e(itemStack.func_77976_d());
                    continue;
                }
                return null;
            }
            if (!ItemStack.func_77989_b((ItemStack)container.func_75139_a(i).func_75211_c(), (ItemStack)itemStack) || container.func_75139_a(i).func_75211_c().func_190916_E() >= container.func_75139_a(i).func_75211_c().func_77976_d()) continue;
            int newStackSize = Math.min(container.func_75139_a(i).func_75211_c().func_190916_E() + itemStack.func_190916_E(), container.func_75139_a(i).func_75211_c().func_77976_d());
            int leftStackSize = container.func_75139_a(i).func_75211_c().func_190916_E() + itemStack.func_190916_E() - newStackSize;
            container.func_75139_a(i).func_75211_c().func_190920_e(newStackSize);
            if (leftStackSize <= 0) {
                return null;
            }
            itemStack.func_190920_e(newStackSize);
        }
        return itemStack;
    }

    public static ItemStack insertItemStackIntoInventory(IInventory inventory, ItemStack itemstack, EnumFacing side) {
        if (itemstack != null && inventory != null) {
            int var3 = itemstack.func_190916_E();
            if (inventory instanceof ISidedInventory) {
                int var6;
                ISidedInventory var4 = (ISidedInventory)inventory;
                int[] var5 = var4.func_180463_a(side);
                if (var5 == null) {
                    return itemstack;
                }
                for (var6 = 0; var6 < var5.length && itemstack != null; ++var6) {
                    ItemStack var7;
                    if (!var4.func_180462_a(var5[var6], itemstack, side) || !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)(var7 = inventory.func_70301_a(var5[var6])))) continue;
                    itemstack = MOInventoryHelper.addToOccupiedInventorySlot((IInventory)var4, var5[var6], itemstack, var7);
                }
                for (var6 = 0; var6 < var5.length && itemstack != null; ++var6) {
                    if (inventory.func_70301_a(var5[var6]) != null || !var4.func_180462_a(var5[var6], itemstack, side)) continue;
                    itemstack = MOInventoryHelper.addToEmptyInventorySlot((IInventory)var4, var5[var6], itemstack);
                }
            } else {
                int var9;
                int var8 = inventory.func_70302_i_();
                for (var9 = 0; var9 < var8 && itemstack != null; ++var9) {
                    ItemStack var10 = inventory.func_70301_a(var9);
                    if (!ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)var10)) continue;
                    itemstack = MOInventoryHelper.addToOccupiedInventorySlot(inventory, var9, itemstack, var10);
                }
                for (var9 = 0; var9 < var8 && itemstack != null; ++var9) {
                    if (!StackUtils.isNullOrEmpty(inventory.func_70301_a(var9))) continue;
                    itemstack = MOInventoryHelper.addToEmptyInventorySlot(inventory, var9, itemstack);
                }
            }
            if (itemstack == null || itemstack.func_190916_E() != var3) {
                inventory.func_70296_d();
            }
            return itemstack;
        }
        return null;
    }

    public static ItemStack addToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack one, ItemStack two) {
        int maxSize = Math.min(inventory.func_70297_j_(), one.func_77976_d());
        if (one.func_190916_E() + two.func_190916_E() > maxSize) {
            int remanningSize = maxSize - two.func_190916_E();
            two.func_190920_e(maxSize);
            one.func_190918_g(remanningSize);
            inventory.func_70299_a(slot, two);
            return one;
        }
        two.func_190917_f(Math.min(one.func_190916_E(), maxSize));
        inventory.func_70299_a(slot, two);
        return maxSize >= one.func_190916_E() ? ItemStack.field_190927_a : one.func_77979_a(one.func_190916_E() - maxSize);
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack itemStack) {
        if (!inventory.func_94041_b(slot, itemStack)) {
            return itemStack;
        }
        int inventoryStackLimit = inventory.func_70297_j_();
        ItemStack newItemStack = itemStack.func_77946_l();
        newItemStack.func_190920_e(Math.min(itemStack.func_190916_E(), inventoryStackLimit));
        inventory.func_70299_a(slot, newItemStack);
        return inventoryStackLimit >= itemStack.func_190916_E() ? null : itemStack.func_77979_a(itemStack.func_190916_E() - inventoryStackLimit);
    }

    public static boolean mergeItemStack(List<Slot> var0, ItemStack var1, int var2, int var3, boolean var4) {
        return MOInventoryHelper.mergeItemStack(var0, var1, var2, var3, var4, true);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int var2, int var3, boolean var4, boolean var5) {
        int var11;
        ItemStack var10;
        Slot var9;
        int var7;
        int var8;
        boolean var6 = false;
        int n = var8 = !var4 ? 1 : -1;
        if (stack.func_77985_e()) {
            for (var7 = !var4 ? var2 : var3 - 1; stack.func_190916_E() > 0 && (!var4 && var7 < var3 || var4 && var7 >= var2); var7 += var8) {
                var9 = slots.get(var7);
                var10 = var9.func_75211_c();
                if (!var9.func_75214_a(stack) || StackUtils.isNullOrEmpty(stack) || !var10.func_77973_b().equals(stack.func_77973_b()) || stack.func_77981_g() && stack.func_77952_i() != var10.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)var10)) continue;
                var11 = var10.func_190916_E() - stack.func_190916_E();
                var10.func_190917_f(stack.func_190916_E());
                int var12 = Math.min(stack.func_77976_d(), var9.func_75219_a());
                if (var11 <= var12) {
                    stack.func_190920_e(0);
                    var10.func_190920_e(var11);
                    var9.func_75218_e();
                    var6 = true;
                    continue;
                }
                if (var10.func_190916_E() >= var12) continue;
                stack.func_190918_g(var12 - var10.func_190916_E());
                var10.func_190920_e(var12);
                var9.func_75218_e();
                var6 = true;
            }
        }
        if (stack.func_190916_E() > 0) {
            int n2 = var7 = !var4 ? var2 : var3 - 1;
            while (stack.func_190916_E() > 0 && (!var4 && var7 < var3 || var4 && var7 >= var2)) {
                var9 = slots.get(var7);
                var10 = var9.func_75211_c();
                if (var9.func_75214_a(stack) && StackUtils.isNullOrEmpty(var10)) {
                    var11 = var5 ? Math.min(stack.func_77976_d(), var9.func_75219_a()) : var9.func_75219_a();
                    var10 = stack.func_77979_a(Math.min(stack.func_190916_E(), var11));
                    var9.func_75215_d(var10);
                    var9.func_75218_e();
                    var6 = true;
                }
                var7 += var8;
            }
        }
        return var6;
    }
}

