/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.List;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MOPhysicsHelper {
    public static boolean insideBounds(Vec3d pos, AxisAlignedBB bounds) {
        return bounds.field_72340_a <= pos.field_72450_a && bounds.field_72338_b <= pos.field_72448_b && bounds.field_72339_c <= pos.field_72449_c && bounds.field_72336_d >= pos.field_72450_a && bounds.field_72337_e >= pos.field_72448_b && bounds.field_72334_f >= pos.field_72449_c;
    }

    public static RayTraceResult rayTrace(EntityLivingBase viewer, World world, double distance, float ticks, Vec3d offset) {
        return MOPhysicsHelper.rayTrace(viewer, world, distance, ticks, offset, false, false);
    }

    public static RayTraceResult rayTrace(EntityLivingBase viewer, World world, double distance, float ticks, Vec3d offset, boolean checkBlockCollision, boolean onlySolid) {
        return MOPhysicsHelper.rayTrace(viewer, world, distance, ticks, offset, checkBlockCollision, onlySolid, null);
    }

    public static RayTraceResult rayTrace(EntityLivingBase viewer, World world, double distance, float ticks, Vec3d offset, boolean checkBlockCollision, boolean onlySolid, Vec3d dir) {
        return MOPhysicsHelper.rayTrace(MOPhysicsHelper.getPosition(viewer, ticks), world, distance, ticks, offset, checkBlockCollision, onlySolid, dir, viewer);
    }

    public static RayTraceResult rayTrace(Vec3d fromPos, World world, double distance, float ticks, Vec3d offset, boolean checkBlockCollision, boolean onlySolid, Vec3d dir, EntityLivingBase viewer) {
        RayTraceResult objectMouseOver = null;
        Entity pointedEntity = null;
        if (world != null) {
            if (dir == null) {
                dir = viewer.func_70676_i(ticks);
            }
            objectMouseOver = MOPhysicsHelper.rayTraceForBlocks(fromPos, world, distance, ticks, offset, checkBlockCollision, onlySolid, dir);
            double d1 = distance;
            Vec3d Vec3d2 = fromPos;
            if (offset != null) {
                Vec3d2 = Vec3d2.func_72441_c(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            if (objectMouseOver != null) {
                d1 = objectMouseOver.field_72307_f.func_72438_d(Vec3d2);
            }
            Vec3d Vec3d22 = Vec3d2.func_72441_c(dir.field_72450_a * distance, dir.field_72448_b * distance, dir.field_72449_c * distance);
            Vec3d Vec3d3 = null;
            float f1 = 1.0f;
            List list = world.func_72839_b((Entity)viewer, viewer.func_174813_aQ().func_72321_a(dir.field_72450_a * distance, dir.field_72448_b * distance, dir.field_72449_c * distance).func_72321_a((double)f1, (double)f1, (double)f1));
            double d2 = d1;
            for (Object aList : list) {
                double d3;
                Entity entity = (Entity)aList;
                if (!entity.func_70067_L()) continue;
                float f2 = entity.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72321_a((double)f2, (double)f2, (double)f2);
                RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(Vec3d2, Vec3d22);
                if (axisalignedbb.func_72318_a(Vec3d2)) {
                    if (!(0.0 < d2) && d2 != 0.0) continue;
                    pointedEntity = entity;
                    Vec3d3 = movingobjectposition == null ? Vec3d2 : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = Vec3d2.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                Vec3d3 = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && d2 < d1) {
                if (objectMouseOver != null) {
                    objectMouseOver.field_72313_a = RayTraceResult.Type.ENTITY;
                    objectMouseOver.field_72308_g = pointedEntity;
                    objectMouseOver.field_72307_f = Vec3d3;
                } else {
                    objectMouseOver = new RayTraceResult(pointedEntity, Vec3d3);
                }
            }
        }
        return objectMouseOver;
    }

    public static RayTraceResult rayTraceForBlocks(EntityLivingBase viewer, World world, double distance, float ticks, Vec3d offset, boolean collisionCheck, boolean onlySolid) {
        return MOPhysicsHelper.rayTraceForBlocks(viewer, world, distance, ticks, offset, collisionCheck, onlySolid, null);
    }

    public static RayTraceResult rayTraceForBlocks(EntityLivingBase viewer, World world, double distance, float ticks, Vec3d offset, boolean collisionCheck, boolean onlySolid, Vec3d dir) {
        return MOPhysicsHelper.rayTraceForBlocks(MOPhysicsHelper.getPosition(viewer, ticks), world, distance, ticks, offset, collisionCheck, onlySolid, dir == null ? viewer.func_70676_i(ticks) : dir);
    }

    public static RayTraceResult rayTraceForBlocks(Vec3d fromPosition, World world, double distance, float ticks, Vec3d offset, boolean collisionCheck, boolean onlySolid, Vec3d dir) {
        Vec3d Vec3d2 = new Vec3d(fromPosition.field_72450_a, fromPosition.field_72448_b, fromPosition.field_72449_c);
        if (offset != null) {
            Vec3d2 = Vec3d2.func_72441_c(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        }
        Vec3d Vec3d22 = Vec3d2.func_72441_c(dir.field_72450_a * distance, dir.field_72448_b * distance, dir.field_72449_c * distance);
        return world.func_147447_a(Vec3d2, Vec3d22, collisionCheck, onlySolid, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static RayTraceResult mouseRaytraceForBlocks(int mouseX, int mouseY, int width, int height, EntityLivingBase viewer, World world, boolean collisionCheck, boolean onlySolid) {
        Vec3d dir = MOMathHelper.mouseToWorldRay(mouseX, mouseY, width, height);
        Vec3d Vec3d2 = viewer.func_174824_e(1.0f);
        Vec3d Vec3d22 = Vec3d2.func_72441_c(dir.field_72450_a * 32.0, dir.field_72448_b * 32.0, dir.field_72449_c * 32.0);
        return world.func_147447_a(Vec3d2, Vec3d22, false, false, true);
    }

    public static Vec3d getPosition(EntityLivingBase entity, float p_70666_1_) {
        if (p_70666_1_ == 1.0f) {
            return new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)p_70666_1_;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)p_70666_1_;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)p_70666_1_;
        return new Vec3d(d0, d1, d2);
    }
}

