/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.api.matter.IMatterItem;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.init.OverdriveFluids;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MatterHelper {
    public static final String MATTER_UNIT = " kM";

    public static boolean containsMatter(ItemStack item) {
        return MatterHelper.getMatterAmountFromItem(item) > 0;
    }

    public static int getMatterAmountFromItem(ItemStack item) {
        if (item != null && !item.func_190926_b()) {
            if (item.func_77973_b() instanceof IMatterItem) {
                return ((IMatterItem)item.func_77973_b()).getMatter(item);
            }
            return MatterOverdrive.MATTER_REGISTRY.getMatter(item);
        }
        return 0;
    }

    public static int getEnergyFromMatter(int multiply, ItemStack itemStack) {
        int matter = MatterHelper.getMatterAmountFromItem(itemStack);
        return multiply * matter;
    }

    public static int getTotalEnergyFromMatter(int multiply, ItemStack itemStack, int time) {
        int matter = MatterHelper.getMatterAmountFromItem(itemStack);
        return multiply * matter * time;
    }

    public static int Transfer(int amount, IMatterHandler from, IFluidHandler to) {
        int extract = from.extractMatter(amount, true);
        int recived = to.fill(new FluidStack((Fluid)OverdriveFluids.matterPlasma, extract), true);
        from.extractMatter(recived, false);
        return recived;
    }

    private static IRecipe GetRecipeOf(ItemStack item) {
        List recipes = ForgeRegistries.RECIPES.getValues();
        for (Object recipe1 : recipes) {
            IRecipe recipe = (IRecipe)recipe1;
            if (recipe == null || recipe.func_77571_b().func_190926_b() || recipe.func_77571_b().func_77973_b() != item.func_77973_b()) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isMatterScanner(ItemStack item) {
        return item != null && item.func_77973_b() != null && item.func_77973_b() instanceof MatterScanner;
    }

    public static boolean isMatterPatternStorage(ItemStack item) {
        return item != null && item.func_77973_b() != null && item.func_77973_b() instanceof IMatterPatternStorage;
    }

    public static boolean isUpgrade(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof IUpgrade;
    }

    public static boolean CanScan(ItemStack stack) {
        if (MatterHelper.getMatterAmountFromItem(stack) <= 0) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            return block != Blocks.field_150357_h && block != Blocks.field_150350_a;
        }
        return true;
    }

    public static String formatMatter(int matter) {
        return MOStringHelper.formatNumber(matter) + MATTER_UNIT;
    }

    public static String formatMatter(double matter) {
        return MOStringHelper.formatNumber(matter) + MATTER_UNIT;
    }

    public static String formatMatter(int matter, int capacity) {
        return MOStringHelper.formatNumber(matter) + " / " + MOStringHelper.formatNumber(capacity) + MATTER_UNIT;
    }

    public static boolean DropInventory(World world, IInventory inventory, BlockPos pos) {
        if (inventory != null) {
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                ItemStack itemstack = inventory.func_70301_a(i1);
                if (itemstack.func_190926_b()) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), itemstack);
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                }
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
            return true;
        }
        return false;
    }

    public static void DrawMatterInfoTooltip(ItemStack itemStack, int speed, int energyPerTick, List<String> tooltips) {
        int matter = MatterHelper.getMatterAmountFromItem(itemStack);
        if (matter > 0) {
            tooltips.add(TextFormatting.ITALIC.toString() + TextFormatting.BLUE.toString() + "Matter: " + MatterHelper.formatMatter(matter));
            tooltips.add(TextFormatting.ITALIC.toString() + TextFormatting.DARK_RED + "Power: " + MOEnergyHelper.formatEnergy(speed * matter * energyPerTick));
        }
    }
}

