/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.world.GenPositionWorldData;
import matteroverdrive.data.world.WorldPosition2D;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.TileUtils;
import matteroverdrive.world.MOWorldGen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.config.Property;

public class WorldGenGravitationalAnomaly
extends WorldGenerator
implements IConfigSubscriber {
    public final Map<Integer, Integer> yLevelMap = new HashMap<Integer, Integer>();
    private final HashSet<Integer> blacklist = new HashSet();
    private final HashSet<Integer> whitelist = new HashSet();
    private float defaultChance;
    private float chance;
    private int minMatter;
    private int maxMatter;
    private String name;

    public WorldGenGravitationalAnomaly(String name, float chance, int minMatter, int maxMatter) {
        this.defaultChance = chance;
        this.chance = chance;
        this.minMatter = minMatter;
        this.maxMatter = maxMatter;
        this.name = name;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (this.isWorldValid(world) && this.isPosValid(world, pos) && random.nextFloat() < this.chance && world.func_175656_a(pos, MatterOverdrive.BLOCKS.gravitational_anomaly.func_176223_P())) {
            TileEntityGravitationalAnomaly anomaly = TileUtils.getNullableTileEntity((IBlockAccess)world, pos, TileEntityGravitationalAnomaly.class);
            if (anomaly == null) {
                anomaly = new TileEntityGravitationalAnomaly(this.minMatter + random.nextInt(this.maxMatter - this.minMatter));
                world.func_175690_a(pos, (TileEntity)anomaly);
            } else {
                anomaly.setMass(this.minMatter + random.nextInt(this.maxMatter - this.minMatter));
                anomaly.func_70296_d();
            }
            GenPositionWorldData data = MOWorldGen.getWorldPositionData(world);
            data.addPosition(this.name, new WorldPosition2D(pos.func_177958_n(), pos.func_177952_p()));
        }
        return false;
    }

    private boolean isPosValid(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    private boolean isWorldValid(World world) {
        if (!this.whitelist.isEmpty()) {
            return this.whitelist.contains(world.field_73011_w.getDimension()) && !this.blacklist.contains(world.field_73011_w.getDimension());
        }
        return !this.blacklist.contains(world.field_73011_w.getDimension());
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        String[] strings;
        this.chance = config.config.getFloat("gravitational anomaly spawn chance", String.format("%s.gravitational_anomaly", "world gen"), this.defaultChance, 0.0f, 1.0f, "Spawn Chance of Gravity Anomaly pre chunk");
        this.yLevelMap.clear();
        for (String s : strings = config.config.getStringList("gravitational anomaly spawn y level", String.format("%s.gravitational_anomaly", "world gen"), new String[0], "Spawn Y level of the Gravity Anomaly")) {
            String[] split = s.split(":");
            this.yLevelMap.put(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
        }
        this.loadWhitelist(config);
        this.loadBlacklist(config);
    }

    private void loadWhitelist(ConfigurationHandler configurationHandler) {
        int[] dimentions;
        this.whitelist.clear();
        Property whitelistProp = configurationHandler.config.get(String.format("%s.gravitational_anomaly", "world gen"), "whitelist", new int[]{-1, 0});
        whitelistProp.setComment("Gravitational Anomaly Dimension ID whitelist");
        for (int dimention : dimentions = whitelistProp.getIntList()) {
            this.whitelist.add(dimention);
        }
    }

    private void loadBlacklist(ConfigurationHandler configurationHandler) {
        int[] dimentions;
        this.blacklist.clear();
        Property blacklistProp = configurationHandler.config.get(String.format("%s.gravitational_anomaly", "world gen"), "blacklist", new int[0]);
        blacklistProp.setComment("Gravitational Anomaly Dimension ID blacklist");
        for (int dimention : dimentions = blacklistProp.getIntList()) {
            this.blacklist.add(dimention);
        }
    }
}

