/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world.buildings;

import java.util.Random;
import matteroverdrive.data.world.GenPositionWorldData;
import matteroverdrive.data.world.WorldPosition2D;
import matteroverdrive.util.MOLog;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.MOWorldGen;
import matteroverdrive.world.buildings.IMOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.apache.logging.log4j.Level;

public abstract class MOWorldGenBuilding<T extends WorldGenBuildingWorker>
extends MOImageGen<T>
implements IMOWorldGenBuilding<T> {
    protected Block[] validSpawnBlocks;
    int yOffset = -1;
    int maxDistanceToAir = 2;
    String name;

    public MOWorldGenBuilding(String name, ResourceLocation texture, int layerWidth, int layerHeight) {
        super(texture, layerWidth, layerHeight);
        this.name = name;
        this.validSpawnBlocks = new Block[]{Blocks.field_150348_b, Blocks.field_150349_c, Blocks.field_150346_d};
    }

    @Override
    public void generate(Random random, BlockPos pos, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, int layer, int placeNotify, T worker) {
        this.generateFromImage(world, random, pos.func_177982_a(0, this.getYOffset(), 0), layer, placeNotify, worker);
    }

    public boolean locationIsValidSpawn(World world, BlockPos pos) {
        int distanceToAir = 0;
        IBlockState blockState = world.func_180495_p(pos);
        while (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (distanceToAir > this.getMaxDistanceToAir()) {
                return false;
            }
            blockState = world.func_180495_p(pos.func_177982_a(0, ++distanceToAir, 0));
        }
        pos = pos.func_177982_a(0, distanceToAir - 1, 0);
        IBlockState block = world.func_180495_p(pos);
        IBlockState blockAbove = world.func_180495_p(pos.func_177982_a(0, 1, 0));
        IBlockState blockBelow = world.func_180495_p(pos.func_177982_a(0, -1, 0));
        for (Block x : this.getValidSpawnBlocks()) {
            if (!blockAbove.func_177230_c().isAir(blockAbove, (IBlockAccess)world, pos.func_177982_a(0, 1, 0))) {
                return false;
            }
            if (block.func_177230_c() == x) {
                return true;
            }
            if (block.func_177230_c() != Blocks.field_150433_aE || blockBelow.func_177230_c() != x) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected int getMaxDistanceToAir() {
        return this.maxDistanceToAir;
    }

    public void setMaxDistanceToAir(int maxDistanceToAir) {
        this.maxDistanceToAir = maxDistanceToAir;
    }

    protected Block[] getValidSpawnBlocks() {
        return this.validSpawnBlocks;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setyOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    protected abstract void onGeneration(Random var1, World var2, BlockPos var3, T var4);

    public abstract boolean shouldGenerate(Random var1, World var2, BlockPos var3);

    public boolean isLocationValid(World world, BlockPos pos) {
        return this.locationIsValidSpawn(world, pos) && this.locationIsValidSpawn(world, pos.func_177982_a(this.layerWidth, 0, 0)) && this.locationIsValidSpawn(world, pos.func_177982_a(this.layerWidth, 0, this.layerHeight)) && this.locationIsValidSpawn(world, pos.func_177982_a(0, 0, this.layerHeight));
    }

    @Override
    public void onGenerationWorkerCreated(T worker) {
        ((WorldGenBuildingWorker)worker).setWorldGenBuilding(this);
        GenPositionWorldData data = MOWorldGen.getWorldPositionData(((MOImageGen.ImageGenWorker)worker).getWorld());
        data.addPosition(this.getName(), new WorldPosition2D(((MOImageGen.ImageGenWorker)worker).getPos().func_177958_n() + this.layerWidth / 2, ((MOImageGen.ImageGenWorker)worker).getPos().func_177952_p() + this.layerHeight / 2));
    }

    public boolean isFarEnoughFromOthers(World world, int x, int z, int minDistance) {
        GenPositionWorldData worldData = MOWorldGen.getWorldPositionData(world);
        if (worldData != null) {
            return worldData.isFarEnough(this.getName(), x, z, minDistance);
        }
        return true;
    }

    public static class WorldGenBuildingWorker
    extends MOImageGen.ImageGenWorker {
        MOWorldGenBuilding worldGenBuilding;

        public void setWorldGenBuilding(MOWorldGenBuilding worldGenBuilding) {
            this.worldGenBuilding = worldGenBuilding;
            this.worldGenBuilding.manageTextureLoading();
        }

        @Override
        public boolean generate() {
            try {
                if (this.currentLayer >= this.worldGenBuilding.getLayerCount()) {
                    this.worldGenBuilding.onGeneration(this.random, this.getWorld(), this.getPos(), this);
                    return true;
                }
                this.worldGenBuilding.generate(this.random, this.getPos(), this.getWorld(), this.getChunkGenerator(), this.getChunkProvider(), this.currentLayer, this.getPlaceNotify(), this);
                ++this.currentLayer;
                return false;
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while generating layer %s of %s", this.currentLayer, this.worldGenBuilding.getName());
                return false;
            }
        }
    }
}

