/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.recipes;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.extraplanets.recipes.ExtraPlanets_MachineRecipes;
import com.mjr.extraplanets.recipes.MarsRoverRecipes;
import com.mjr.extraplanets.recipes.Tier10ElectricRocketRecipes;
import com.mjr.extraplanets.recipes.Tier10RocketRecipes;
import com.mjr.extraplanets.recipes.Tier4RocketRecipes;
import com.mjr.extraplanets.recipes.Tier5RocketRecipes;
import com.mjr.extraplanets.recipes.Tier6RocketRecipes;
import com.mjr.extraplanets.recipes.Tier7RocketRecipes;
import com.mjr.extraplanets.recipes.Tier8RocketRecipes;
import com.mjr.extraplanets.recipes.Tier9RocketRecipes;
import com.mjr.extraplanets.recipes.VenusRoverRecipes;
import com.mjr.extraplanets.util.GCRecipeUtilities;
import com.mjr.mjrlegendslib.util.RecipeUtilities;
import java.util.HashMap;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ExtraPlanets_Recipes {
    public static void init() {
        ExtraPlanets_Recipes.registerRocketCraftingRecipes();
        ExtraPlanets_Recipes.registerFurnaceRecipes();
        ExtraPlanets_Recipes.registerSatellitesRecipes();
    }

    public static void initEvent() {
        ExtraPlanets_Recipes.registerCompressorRecipes();
        ExtraPlanets_Recipes.registerCircuitFabricatorRecipes();
        ExtraPlanets_Recipes.registerExtraPlanetMachineRecipes();
    }

    private static void registerRocketCraftingRecipes() {
        if (Config.MERCURY) {
            Tier4RocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.JUPITER) {
            Tier5RocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.SATURN) {
            Tier6RocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.URANUS) {
            Tier7RocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.NEPTUNE) {
            Tier8RocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.PLUTO) {
            Tier9RocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.ERIS) {
            Tier10RocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.ERIS && Config.KEPLER22B && Config.ELECTRIC_ROCKET) {
            Tier10ElectricRocketRecipes.registerRocketCraftingRecipe();
        }
        if (Config.MARS_ROVER) {
            MarsRoverRecipes.registerRoverCraftingRecipe();
        }
        if (Config.VENUS_ROVER) {
            VenusRoverRecipes.registerRoverCraftingRecipe();
        }
    }

    private static void registerFurnaceRecipes() {
        if (Config.MERCURY) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.MERCURY_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.MERCURY_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.MERCURY_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.MERCURY_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.INGOT_MERCURY), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.MERCURY_BLOCKS, 1, 10), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5), (float)0.0f);
        }
        if (Config.CERES) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.CERES_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.CERES_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.CERES_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.CERES_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.INGOT_URANIUM, 1), (float)0.0f);
        }
        if (Config.JUPITER) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.JUPITER_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.JUPITER_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.JUPITER_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.JUPITER_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.JUPITER_BLOCKS, 1, 7), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 7), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.JUPITER_BLOCKS, 1, 11), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 8), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.VOLCANIC_ROCK), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 12), (float)0.0f);
        }
        if (Config.SATURN) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.SATURN_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.SATURN_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.SATURN_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.SATURN_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 5), (float)0.0f);
        }
        if (Config.URANUS) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.URANUS_BLOCKS, 1, 3), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 5), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.URANUS_BLOCKS, 1, 7), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 7), (float)0.0f);
        }
        if (Config.NEPTUNE) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.NEPTUNE_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.NEPTUNE_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.NEPTUNE_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.NEPTUNE_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.NEPTUNE_BLOCKS, 1, 10), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 6), (float)0.0f);
        }
        if (Config.PLUTO) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.PLUTO_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.PLUTO_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.PLUTO_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.PLUTO_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 5), (float)0.0f);
        }
        if (Config.ERIS) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.ERIS_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.ERIS_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.ERIS_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.ERIS_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 5), (float)0.0f);
        }
        if (Config.CALLISTO) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.CALLISTO_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.CALLISTO_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.CALLISTO_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.DEIMOS) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.DEIMOS_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.DEIMOS_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.DEIMOS_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.EUROPA) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.EUROPA_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.EUROPA_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.EUROPA_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.GANYMEDE) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.IO) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.IO_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.IO_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.IO_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.PHOBOS) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.PHOBOS_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.PHOBOS_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.PHOBOS_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.TRITON) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TRITON_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TRITON_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TRITON_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.RHEA) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.RHEA_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.RHEA_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.RHEA_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.TITAN) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TITAN_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TITAN_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TITAN_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.OBERON) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.OBERON_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.OBERON_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.OBERON_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.TITANIA) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TITANIA_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TITANIA_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.TITANIA_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.IAPETUS) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.IAPETUS_BLOCKS, 1, 5), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.IAPETUS_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.IAPETUS_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
        }
        if (Config.KEPLER22B && Config.KEPLER_SOLAR_SYSTEMS) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 4), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 3), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 2), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotIron").get(0)), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 12), (ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 1), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 13), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 5), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 5), (ItemStack)new ItemStack(Blocks.field_150402_ci, 1, 0), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 6), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 0), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 7), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 1), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 8), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 2), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 9), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 3), (float)0.0f);
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.KEPLER22B_BLOCKS, 1, 10), (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 4), (float)0.0f);
        }
        if (Config.ORE_LEAD_GENERATION) {
            RecipeUtilities.addSmelting((ItemStack)new ItemStack(ExtraPlanets_Blocks.ORE_LEAD, 1, 0), (ItemStack)new ItemStack(ExtraPlanets_Items.INGOT_LEAD), (float)0.0f);
        }
    }

    private static void registerCompressorRecipes() {
        if (Config.MERCURY) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.COMPRESSED_MERCURY, 1, 0), new ItemStack(ExtraPlanets_Items.INGOT_MERCURY, 1, 0), new ItemStack(ExtraPlanets_Items.INGOT_MERCURY, 1, 0));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 3), new ItemStack(AsteroidsItems.basicItem, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.COMPRESSED_MERCURY, 1, 0), new ItemStack(ExtraPlanets_Items.COMPRESSED_MERCURY, 1, 0), new ItemStack(ExtraPlanets_Items.COMPRESSED_MERCURY, 1, 0), new ItemStack(ExtraPlanets_Items.COMPRESSED_MERCURY, 1, 0));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 3, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(Items.field_151045_i), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 6));
        }
        if (Config.JUPITER) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 7), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 7));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 4));
        }
        if (Config.SATURN) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 4));
        }
        if (Config.URANUS) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 4));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 6));
        }
        if (Config.NEPTUNE) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5));
        }
        if (Config.PLUTO) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 4));
        }
        if (Config.ERIS) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 3), new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 4), new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 4));
        }
        if (Config.KEPLER22B) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 6), new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 5));
        }
        if (Config.PRESSURE || Config.RADIATION) {
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_1_ARMOR_LAYER, 1, 0), "ingotAluminum", "ingotAluminum", "ingotAluminum", "ingotAluminum");
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_2_ARMOR_LAYER, 1, 0), new ItemStack(AsteroidsItems.basicItem, 1, 0), new ItemStack(AsteroidsItems.basicItem, 1, 0), new ItemStack(AsteroidsItems.basicItem, 1, 0), new ItemStack(AsteroidsItems.basicItem, 1, 0));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_3_ARMOR_LAYER, 1, 0), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5));
            GCRecipeUtilities.addCompresssorShapelessRecipe(new ItemStack(ExtraPlanets_Items.TIER_4_ARMOR_LAYER, 1, 0), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5));
        }
    }

    private static void registerCircuitFabricatorRecipes() {
        NonNullList silicons = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon);
        int siliconCount = silicons.size();
        for (int j = 0; j <= siliconCount; ++j) {
            ItemStack silicon = j == 0 ? new ItemStack(GCItems.basicItem, 1, 2) : (ItemStack)silicons.get(j - 1);
            NonNullList input1 = NonNullList.func_191196_a();
            input1.add((Object)new ItemStack(Items.field_151045_i));
            input1.add((Object)silicon);
            input1.add((Object)silicon);
            input1.add((Object)new ItemStack(Items.field_151137_ax));
            input1.add((Object)new ItemStack(Blocks.field_150379_bu));
            GCRecipeUtilities.addCircuitFabricatorRecipe(new ItemStack(ExtraPlanets_Items.WAFERS, 3, 0), (NonNullList<Object>)input1);
            input1 = NonNullList.func_191196_a();
            input1.add((Object)new ItemStack(AsteroidsItems.basicItem));
            input1.add((Object)silicon);
            input1.add((Object)silicon);
            input1.add((Object)new ItemStack(Items.field_151137_ax));
            input1.add((Object)new ItemStack(Blocks.field_150429_aA));
            GCRecipeUtilities.addCircuitFabricatorRecipe(new ItemStack(ExtraPlanets_Items.WAFERS, 3, 2), (NonNullList<Object>)input1);
            if (Config.MERCURY) {
                input1 = NonNullList.func_191196_a();
                input1.add((Object)new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5));
                input1.add((Object)silicon);
                input1.add((Object)silicon);
                input1.add((Object)new ItemStack(Items.field_151137_ax));
                input1.add((Object)new ItemStack(Items.field_151132_bS));
                GCRecipeUtilities.addCircuitFabricatorRecipe(new ItemStack(ExtraPlanets_Items.WAFERS, 3, 1), (NonNullList<Object>)input1);
            }
            if (Config.JUPITER) {
                input1 = NonNullList.func_191196_a();
                input1.add((Object)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 8));
                input1.add((Object)silicon);
                input1.add((Object)silicon);
                input1.add((Object)new ItemStack(Items.field_151137_ax));
                input1.add((Object)new ItemStack(Items.field_151107_aW));
                GCRecipeUtilities.addCircuitFabricatorRecipe(new ItemStack(ExtraPlanets_Items.WAFERS, 3, 3), (NonNullList<Object>)input1);
            }
            if (Config.NEPTUNE) {
                input1 = NonNullList.func_191196_a();
                input1.add((Object)new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 6));
                input1.add((Object)silicon);
                input1.add((Object)silicon);
                input1.add((Object)new ItemStack(Items.field_151137_ax));
                input1.add((Object)new ItemStack(Items.field_151107_aW));
                GCRecipeUtilities.addCircuitFabricatorRecipe(new ItemStack(ExtraPlanets_Items.WAFERS, 3, 4), (NonNullList<Object>)input1);
            }
            if (!Config.URANUS) continue;
            input1 = NonNullList.func_191196_a();
            input1.add((Object)new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 7));
            input1.add((Object)silicon);
            input1.add((Object)silicon);
            input1.add((Object)new ItemStack(Items.field_151137_ax));
            input1.add((Object)new ItemStack(Items.field_151107_aW));
            GCRecipeUtilities.addCircuitFabricatorRecipe(new ItemStack(ExtraPlanets_Items.WAFERS, 3, 5), (NonNullList<Object>)input1);
        }
    }

    private static void registerSatellitesRecipes() {
        HashMap<Object, Integer> inputMap;
        if (Config.MERCURY_SPACE_STATION && Config.MERCURY) {
            inputMap = new HashMap<Object, Integer>();
            inputMap.put("ingotTin", 32);
            inputMap.put("waferAdvanced", 1);
            inputMap.put(new ItemStack(ExtraPlanets_Items.INGOT_MERCURY, 1, 0), 24);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.MERCURY_SPACE_STATION_ID, Config.MERCURY_ID, inputMap);
        }
        if (Config.VENUS_SPACE_STATION) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put("waferAdvanced", 1);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 5), 24);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.VENUS_SPACE_STATION_ID, VenusModule.planetVenus.getDimensionID(), inputMap);
        }
        if (Config.CERES_SPACE_STATION && Config.CERES) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put("waferAdvanced", 1);
            inputMap.put("ingotUranium", 24);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.CERES_SPACE_STATION_ID, Config.CERES_ID, inputMap);
        }
        if (Config.MARS_SPACE_STATION && MarsModule.planetMars != null) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put("waferAdvanced", 1);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.MARS_SPACE_STATION_ID, MarsModule.planetMars.getDimensionID(), inputMap);
        }
        if (Config.JUPITER_SPACE_STATION && Config.JUPITER) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 5), 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.WAFERS, 1, 3), 3);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.JUPITER_SPACE_STATION_ID, Config.JUPITER_ID, inputMap);
        }
        if (Config.SATURN_SPACE_STATION && Config.SATURN) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put("waferAdvanced", 1);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 5), 24);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.SATURN_SPACE_STATION_ID, Config.SATURN_ID, inputMap);
        }
        if (Config.URANUS_SPACE_STATION && Config.URANUS) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 5), 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.WAFERS, 1, 5), 3);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.URANUS_SPACE_STATION_ID, Config.URANUS_ID, inputMap);
        }
        if (Config.NEPTUNE_SPACE_STATION && Config.NEPTUNE) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 5), 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.WAFERS, 1, 4), 3);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.NEPTUNE_SPACE_STATION_ID, Config.NEPTUNE_ID, inputMap);
        }
        if (Config.PLUTO_SPACE_STATION && Config.PLUTO) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put("waferAdvanced", 1);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 5), 24);
            inputMap.put(Items.field_151042_j, 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.PLUTO_SPACE_STATION_ID, Config.PLUTO_ID, inputMap);
        }
        if (Config.ERIS_SPACE_STATION && Config.ERIS) {
            inputMap = new HashMap();
            inputMap.put("ingotTin", 32);
            inputMap.put("waferAdvanced", 1);
            inputMap.put(Items.field_151042_j, 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 5), 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.ERIS_SPACE_STATION_ID, Config.ERIS_ID, inputMap);
        }
        if (Config.KEPLER22B_SPACE_STATION && Config.KEPLER22B && Config.KEPLER_SOLAR_SYSTEMS) {
            inputMap = new HashMap();
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 0), 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 1), 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 2), 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 3), 24);
            inputMap.put(new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 4), 24);
            GCRecipeUtilities.addSpaceStationRecipe(Config.KEPLER22B_SPACE_STATION_ID, Config.KEPLER22B_ID, inputMap);
        }
    }

    private static void registerExtraPlanetMachineRecipes() {
        ExtraPlanets_MachineRecipes.addBlockSmasherRecipe(new ItemStack(ExtraPlanets_Items.POTASH_SHARDS, 3, 0), new ItemStack(ExtraPlanets_Blocks.ORE_POTASH));
        ExtraPlanets_MachineRecipes.addSolarEvaporationChamberRecipe(new ItemStack(ExtraPlanets_Items.POTASSIUM, 1, 0), new ItemStack(ExtraPlanets_Items.POTASH_SHARDS, 12, 0));
    }
}

