/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tileEntities.machines;

import com.mjr.extraplanets.blocks.machines.AdvancedFuelLoader;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityAdvancedFuelLoader
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandlerWrapper,
ILandingPadAttachable,
IMachineSides {
    private final int tankCapacity = 24000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public IFuelable attachedFuelable;
    private boolean loadedFuelLastTick = false;
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityAdvancedFuelLoader() {
        this.storage.setMaxExtract(60.0f);
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.loadedFuelLastTick = false;
            FluidStack liquidContained = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(1)));
            if (FluidUtil.isFuel((FluidStack)liquidContained)) {
                FluidUtil.loadFromContainer((FluidTank)this.fuelTank, (Fluid)GCFluids.fluidFuel, this.stacks, (int)1, (int)liquidContained.amount);
            }
            if (this.ticks % 100 == 0) {
                this.attachedFuelable = null;
                for (EnumFacing dir : EnumFacing.values()) {
                    TileEntity pad = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, dir);
                    if (pad instanceof TileEntityMulti) {
                        TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                        if (!(mainTile instanceof IFuelable)) continue;
                        this.attachedFuelable = (IFuelable)mainTile;
                        break;
                    }
                    if (!(pad instanceof IFuelable)) continue;
                    this.attachedFuelable = (IFuelable)pad;
                    break;
                }
            }
            if (this.fuelTank != null && this.fuelTank.getFluid() != null && this.fuelTank.getFluid().amount > 0) {
                FluidStack liquid = new FluidStack(GCFluids.fluidFuel, 5);
                if (this.attachedFuelable != null && this.hasEnoughEnergyToRun && !this.disabled) {
                    int filled = this.attachedFuelable.addFuel(liquid, true);
                    this.loadedFuelLastTick = filled > 0;
                    this.fuelTank.drain(filled, true);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.stacks = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(par1NBTTagCompound.func_74775_l("fuelTank"));
        }
        this.readMachineSidesFromNBT(par1NBTTagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        this.addMachineSidesToNBT(nbt);
        return nbt;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"container.advanced.fuelloader.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slotID, ItemStack itemStack, EnumFacing side) {
        return this.func_94041_b(slotID, itemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        if (slotID == 1 && itemStack != null) {
            return FluidUtil.isEmptyContainer((ItemStack)itemStack);
        }
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 1 && itemStack != null && itemStack.func_77973_b() == GCItems.fuelCanister || slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.getPipeInputDirection().equals((Object)from)) {
            return this.fuelTank.getFluid() == null || this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity();
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (this.getPipeInputDirection().equals((Object)from) && resource != null && FluidUtil.testFuel((String)FluidRegistry.getFluidName((FluidStack)resource))) {
            used = this.fuelTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.getPipeInputDirection().equals((Object)from)) {
            return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
        }
        return null;
    }

    public boolean shouldUseEnergy() {
        return this.fuelTank.getFluid() != null && this.fuelTank.getFluid().amount > 0 && !this.getDisabled(0) && this.loadedFuelLastTick;
    }

    public boolean canAttachToLandingPad(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof AdvancedFuelLoader) {
            return (EnumFacing)state.func_177229_b((IProperty)AdvancedFuelLoader.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            return direction == this.getPipeInputDirection();
        }
        return false;
    }

    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    public EnumFacing getPipeInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.PIPE_IN)) {
            default: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
            case LEFT: 
        }
        return this.getFront().func_176746_e();
    }

    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN, IMachineSides.MachineSide.PIPE_IN};
    }

    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT, IMachineSides.Face.RIGHT};
    }

    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    public IMachineSidesProperties getConfigurationType() {
        return AdvancedFuelLoader.MACHINESIDES_RENDERTYPE;
    }
}

