/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tileEntities.machines;

import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.machines.BasicDensifier;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityBasicDensifier
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandlerWrapper {
    private final int tankCapacity = 20000;
    private int amountDrain = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank inputTank;
    public static final int PROCESS_TIME_REQUIRED = 5;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private ItemStack producingStack = null;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int outputTextureOffsetX;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int outputTextureOffsetY;

    public TileEntityBasicDensifier() {
        this.inputTank = new FluidTank(this.tankCapacity);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return null;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.checkFluidTankTransfer(2, this.inputTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = 5;
                } else if (--this.processTicks <= 0) {
                    this.updateOutput();
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? 5 : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        if (this.func_70301_a(slot) != null && !FluidUtil.isEmptyContainer((ItemStack)this.func_70301_a(slot)) && FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)) != null && FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() != null) {
            if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid().equals(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID)) {
                if (this.inputTank.getFluid() == null) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID, 0));
                    tank.fill(FluidRegistry.getFluidStack((String)"liquid_caramel_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() == this.inputTank.getFluid().getFluid()) {
                    tank.fill(FluidRegistry.getFluidStack((String)"liquid_caramel_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                }
            } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid().equals(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID)) {
                if (this.inputTank.getFluid() == null) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID, 0));
                    tank.fill(FluidRegistry.getFluidStack((String)"liquid_chocolate_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() == this.inputTank.getFluid().getFluid()) {
                    tank.fill(FluidRegistry.getFluidStack((String)"liquid_chocolate_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                }
            } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid().equals(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID)) {
                if (this.inputTank.getFluid() == null) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID, 0));
                    tank.fill(FluidRegistry.getFluidStack((String)"nitrogen_ice_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() == this.inputTank.getFluid().getFluid()) {
                    tank.fill(FluidRegistry.getFluidStack((String)"nitrogen_ice_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                }
            } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid().equals(ExtraPlanets_Fluids.GLOWSTONE_FLUID)) {
                if (this.inputTank.getFluid() == null) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.GLOWSTONE_FLUID, 0));
                    tank.fill(FluidRegistry.getFluidStack((String)"glowstone_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() == this.inputTank.getFluid().getFluid()) {
                    tank.fill(FluidRegistry.getFluidStack((String)"glowstone_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                }
            } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid().equals(ExtraPlanets_Fluids.NITROGEN_FLUID)) {
                if (this.inputTank.getFluid() == null) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.NITROGEN_FLUID, 0));
                    tank.fill(FluidRegistry.getFluidStack((String)"nitrogen_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() == this.inputTank.getFluid().getFluid()) {
                    tank.fill(FluidRegistry.getFluidStack((String)"nitrogen_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                }
            } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid().equals(ExtraPlanets_Fluids.FROZEN_WATER_FLUID)) {
                if (this.inputTank.getFluid() == null) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.FROZEN_WATER_FLUID, 0));
                    tank.fill(FluidRegistry.getFluidStack((String)"frozen_water_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() == this.inputTank.getFluid().getFluid()) {
                    tank.fill(FluidRegistry.getFluidStack((String)"frozen_water_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                }
            } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid().equals(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID)) {
                if (this.inputTank.getFluid() == null) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID, 0));
                    tank.fill(FluidRegistry.getFluidStack((String)"liquid_hydrocarbon_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                } else if (FluidUtil.getFluidContained((ItemStack)this.func_70301_a(slot)).getFluid() == this.inputTank.getFluid().getFluid()) {
                    tank.fill(FluidRegistry.getFluidStack((String)"liquid_hydrocarbon_fluid", (int)1000), true);
                    this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                }
            }
        }
    }

    public void updateOutput() {
        if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID, 0))) {
            this.producingStack = new ItemStack(ExtraPlanets_Items.CARAMEL_BAR, 6);
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID, 0))) {
            this.producingStack = new ItemStack(ExtraPlanets_Items.CHOCOLATE_BAR, 6);
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID, 0))) {
            this.producingStack = new ItemStack(Blocks.field_150432_aD, 6);
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.GLOWSTONE_FLUID, 0))) {
            this.producingStack = new ItemStack(Blocks.field_150426_aN, 1);
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.NITROGEN_FLUID, 0))) {
            this.producingStack = new ItemStack(ExtraPlanets_Blocks.FROZEN_NITROGEN, 2);
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.FROZEN_WATER_FLUID, 0))) {
            this.producingStack = new ItemStack(Blocks.field_150432_aD, 3);
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID, 0))) {
            this.producingStack = new ItemStack(Items.field_151044_h, 3);
        }
    }

    public void updateTextureOffset() {
        if (this.inputTank.getFluid() == null) {
            return;
        }
        if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID, 0))) {
            this.outputTextureOffsetX = 48;
            this.outputTextureOffsetY = 0;
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID, 0))) {
            this.outputTextureOffsetX = 16;
            this.outputTextureOffsetY = 0;
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID, 0))) {
            this.outputTextureOffsetX = 0;
            this.outputTextureOffsetY = 0;
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.GLOWSTONE_FLUID, 0))) {
            this.outputTextureOffsetX = 64;
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.NITROGEN_FLUID, 0))) {
            this.outputTextureOffsetX = 0;
            this.outputTextureOffsetY = 45;
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.FROZEN_WATER_FLUID, 0))) {
            this.outputTextureOffsetX = 16;
            this.outputTextureOffsetY = 45;
        } else if (this.inputTank.getFluid().equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID, 0))) {
            this.outputTextureOffsetX = 32;
            this.outputTextureOffsetY = 45;
        }
    }

    public int getScaledFuelLevel(int i) {
        return this.inputTank.getFluidAmount() * i / this.inputTank.getCapacity();
    }

    public boolean canProcess() {
        if (this.inputTank.getFluidAmount() <= 0 && this.amountDrain <= 0) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public boolean canCrystallize() {
        if (this.producingStack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.stacks.get(1)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.stacks.get(1)).func_190926_b() && !((ItemStack)this.stacks.get(1)).func_77969_a(this.producingStack)) {
            return false;
        }
        int result = ((ItemStack)this.stacks.get(1)).func_190926_b() ? 0 : ((ItemStack)this.stacks.get(1)).func_190916_E() + this.producingStack.func_190916_E();
        return result <= this.func_70297_j_() && result <= this.producingStack.func_77976_d();
    }

    public boolean hasInputs() {
        return this.inputTank.getFluidAmount() >= 50;
    }

    public void smeltItem() {
        ItemStack resultItemStack = this.producingStack;
        if (this.canProcess() && this.canCrystallize() && this.hasInputs()) {
            int amountToDrain = 50;
            this.amountDrain += 50;
            this.inputTank.drain(50, true);
            if (this.amountDrain >= 1000) {
                this.amountDrain = 0;
                if (((ItemStack)this.stacks.get(1)).func_190926_b()) {
                    this.stacks.set(1, (Object)resultItemStack.func_77946_l());
                } else if (((ItemStack)this.stacks.get(1)).func_77969_a(resultItemStack)) {
                    if (((ItemStack)this.stacks.get(1)).func_190916_E() + resultItemStack.func_190916_E() > 64) {
                        for (int i = 0; i < ((ItemStack)this.stacks.get(1)).func_190916_E() + resultItemStack.func_190916_E() - 64; ++i) {
                            float var = 0.7f;
                            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + dx, (double)this.func_174877_v().func_177956_o() + dy, (double)this.func_174877_v().func_177952_p() + dz, new ItemStack(resultItemStack.func_77973_b(), 1, resultItemStack.func_77952_i()));
                            entityitem.func_174867_a(10);
                            this.field_145850_b.func_72838_d((Entity)entityitem);
                        }
                        ((ItemStack)this.stacks.get(1)).func_190920_e(64);
                    } else {
                        ((ItemStack)this.stacks.get(1)).func_190917_f(resultItemStack.func_190916_E());
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("inputTank")) {
            this.inputTank.readFromNBT(nbt.func_74775_l("inputTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        if (this.inputTank.getFluid() != null) {
            nbt.func_74782_a("inputTank", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"container.basic.densifier.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemStack);
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty((ItemStack)itemStack) || !this.shouldPullEnergy();
                }
                case 1: {
                    return itemStack.func_77973_b() == ExtraPlanets_Items.IODIDE_SALT;
                }
                case 2: {
                    return itemStack == new ItemStack(Items.field_151133_ar);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: {
                return itemStack.func_77973_b() == ExtraPlanets_Items.IODIDE_SALT;
            }
            case 2: {
                return FluidUtil.isValidContainer((ItemStack)itemStack);
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176735_f();
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BasicDensifier) {
            return (EnumFacing)state.func_177229_b((IProperty)BasicDensifier.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            return direction == this.getInputPipe();
        }
        return false;
    }

    private EnumFacing getInputPipe() {
        return this.getFront().func_176746_e();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getInputPipe()) {
            return this.inputTank.getFluid() == null || this.inputTank.getFluidAmount() < this.inputTank.getCapacity();
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from == this.getInputPipe() && resource != null && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && (resource.equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID, 0)) || resource.equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID, 0)) || resource.equals((Object)new FluidStack(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID, 0)) || resource.equals((Object)new FluidStack(ExtraPlanets_Fluids.GLOWSTONE_FLUID, 0)) || resource.equals((Object)new FluidStack(ExtraPlanets_Fluids.NITROGEN_FLUID, 0)) || resource.equals((Object)new FluidStack(ExtraPlanets_Fluids.FROZEN_WATER_FLUID, 0)) || resource.equals((Object)new FluidStack(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID, 0)))) {
            if (this.inputTank.getFluid() == null) {
                if (resource.getFluid().equals(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID)) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID, 0));
                } else if (resource.getFluid().equals(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID)) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID, 0));
                } else if (resource.getFluid().equals(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID)) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID, 0));
                } else if (resource.getFluid().equals(ExtraPlanets_Fluids.GLOWSTONE_FLUID)) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.GLOWSTONE_FLUID, 0));
                } else if (resource.getFluid().equals(ExtraPlanets_Fluids.NITROGEN_FLUID)) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.NITROGEN_FLUID, 0));
                } else if (resource.getFluid().equals(ExtraPlanets_Fluids.FROZEN_WATER_FLUID)) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.FROZEN_WATER_FLUID, 0));
                } else if (resource.getFluid().equals(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID)) {
                    this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID, 0));
                }
            }
            if (this.inputTank.getFluid().equals((Object)resource) && this.inputTank.getFluidAmount() == 0) {
                this.inputTank.setFluid(resource);
            }
            used = this.inputTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.inputTank)};
    }
}

