/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tileEntities.machines;

import com.mjr.extraplanets.blocks.machines.BasicSmasher;
import com.mjr.extraplanets.recipes.ExtraPlanets_MachineRecipes;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityBasicSmasher
extends TileBaseElectricBlockWithInventory
implements ISidedInventory {
    public static final int PROCESS_TIME_REQUIRED = 50;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private ItemStack producingStack = ItemStack.field_190927_a;

    public void func_73660_a() {
        super.func_73660_a();
        this.producingStack = ExtraPlanets_MachineRecipes.getBlockSmasherOutputForInput((ItemStack)this.stacks.get(1));
        if (!this.field_145850_b.field_72995_K) {
            if (this.canProcess() && this.canOutput() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = 50;
                } else if (--this.processTicks <= 0) {
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? 50 : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        if (this.producingStack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.stacks.get(1)).func_190926_b()) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public boolean canOutput() {
        ItemStack itemStack = this.producingStack;
        if (itemStack == null) {
            return false;
        }
        if (((ItemStack)this.stacks.get(2)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.stacks.get(2)).func_77969_a(itemStack)) {
            return false;
        }
        int result = ((ItemStack)this.stacks.get(2)).func_190926_b() ? 0 : ((ItemStack)this.stacks.get(2)).func_190916_E() + this.producingStack.func_190916_E();
        return result <= this.func_70297_j_() && result <= this.producingStack.func_77976_d();
    }

    public boolean hasInputs() {
        return !((ItemStack)this.stacks.get(1)).func_190926_b() && ((ItemStack)this.stacks.get(1)).func_190916_E() >= ExtraPlanets_MachineRecipes.getBlockSmasherInputForOutput(this.producingStack).func_190916_E();
    }

    public void smeltItem() {
        ItemStack resultItemStack = this.producingStack;
        if (this.canProcess() && this.canOutput() && this.hasInputs()) {
            if (((ItemStack)this.stacks.get(2)).func_190926_b()) {
                this.stacks.set(2, (Object)resultItemStack.func_77946_l());
            } else if (((ItemStack)this.stacks.get(2)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.stacks.get(2)).func_190916_E() + resultItemStack.func_190916_E() > 64) {
                    for (int i = 0; i < ((ItemStack)this.stacks.get(2)).func_190916_E() + resultItemStack.func_190916_E() - 64; ++i) {
                        float var = 0.7f;
                        double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + dx, (double)this.func_174877_v().func_177956_o() + dy, (double)this.func_174877_v().func_177952_p() + dz, new ItemStack(resultItemStack.func_77973_b(), 1, resultItemStack.func_77952_i()));
                        entityitem.func_174867_a(10);
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                    ((ItemStack)this.stacks.get(2)).func_190920_e(64);
                } else {
                    ((ItemStack)this.stacks.get(2)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
            this.func_70298_a(1, ExtraPlanets_MachineRecipes.getBlockSmasherInputForOutput(this.producingStack).func_190916_E());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        return nbt;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"container.basic.smasher.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{2};
        }
        if (side == EnumFacing.UP) {
            return new int[]{1};
        }
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemStack);
                }
                case 1: {
                    for (ItemStack test : ExtraPlanets_MachineRecipes.blockSmasherSlotValidItems) {
                        if (!test.func_77969_a(itemStack)) continue;
                        return true;
                    }
                    break;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty((ItemStack)itemStack) || !this.shouldPullEnergy();
                }
                case 2: {
                    return itemStack.func_77973_b() == this.producingStack.func_77973_b();
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: {
                for (ItemStack test : ExtraPlanets_MachineRecipes.blockSmasherSlotValidItems) {
                    if (!test.func_77969_a(itemStack)) continue;
                    return true;
                }
            }
            case 2: {
                return itemStack.func_77973_b() == this.producingStack.func_77973_b();
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.func_176731_b((int)(((this.func_145832_p() & 3) + 1) % 4));
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BasicSmasher) {
            return (EnumFacing)state.func_177229_b((IProperty)BasicSmasher.FACING);
        }
        return EnumFacing.NORTH;
    }
}

