/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tileEntities.machines;

import com.mjr.extraplanets.api.block.IPowerable;
import com.mjr.extraplanets.blocks.machines.AdvancedFuelLoader;
import com.mjr.extraplanets.blocks.machines.VehicleCharger;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityVehicleChanger
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
ILandingPadAttachable,
IMachineSides {
    public IPowerable attachedPowerable;
    private boolean loadedPowerLastTick = false;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityVehicleChanger() {
        this.storage.setMaxExtract(30.0f);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.loadedPowerLastTick = false;
            if (this.ticks % 100 == 0) {
                this.attachedPowerable = null;
                for (EnumFacing dir : EnumFacing.values()) {
                    TileEntity pad = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, dir);
                    if (pad instanceof TileEntityMulti) {
                        TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                        if (!(mainTile instanceof IPowerable)) continue;
                        this.attachedPowerable = (IPowerable)mainTile;
                        break;
                    }
                    if (!(pad instanceof IPowerable)) continue;
                    this.attachedPowerable = (IPowerable)pad;
                    break;
                }
            }
            if (this.storage.getEnergyStoredGC() > 10.0f && this.attachedPowerable != null && this.hasEnoughEnergyToRun && !this.disabled) {
                float filled = this.attachedPowerable.addPower(10.0f, true);
                this.loadedPowerLastTick = filled == 10.0f;
                this.storage.setEnergyStored(this.storage.getEnergyStoredGC() - filled);
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.stacks = this.readStandardItemsFromNBT(par1NBTTagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound, this.stacks);
        return par1NBTTagCompound;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"container.vehicle.charger.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 1 && itemStack != null && itemStack.func_77973_b() == GCItems.fuelCanister || slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0) && this.loadedPowerLastTick;
    }

    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    public IMachineSidesProperties getConfigurationType() {
        return AdvancedFuelLoader.MACHINESIDES_RENDERTYPE;
    }

    public boolean canAttachToLandingPad(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof VehicleCharger) {
            return (EnumFacing)state.func_177229_b((IProperty)VehicleCharger.FACING);
        }
        return EnumFacing.NORTH;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }
}

