/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class PacketProgrammerUpdate
extends LocationIntPacket<PacketProgrammerUpdate>
implements ILargePayload {
    private NBTTagCompound progWidgets;

    public PacketProgrammerUpdate() {
    }

    public PacketProgrammerUpdate(TileEntityProgrammer te) {
        super(te.func_174877_v());
        this.progWidgets = new NBTTagCompound();
        te.writeProgWidgetsToNBT(this.progWidgets);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        try {
            new PacketBuffer(buffer).func_150786_a(this.progWidgets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        try {
            this.progWidgets = new PacketBuffer(buffer).func_150793_b();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleClientSide(PacketProgrammerUpdate message, EntityPlayer player) {
        this.handleServerSide((PacketProgrammerUpdate)null, player);
    }

    @Override
    public void handleServerSide(PacketProgrammerUpdate message, EntityPlayer player) {
        TileEntity te = message.getTileEntity(player.func_130014_f_());
        if (te instanceof TileEntityProgrammer) {
            ((TileEntityProgrammer)te).readProgWidgetsFromNBT(message.progWidgets);
            ((TileEntityProgrammer)te).saveToHistory();
            if (!player.field_70170_p.field_72995_K) {
                message.updateOtherWatchingPlayers((TileEntityProgrammer)te, player);
            }
        }
    }

    private void updateOtherWatchingPlayers(TileEntityProgrammer te, EntityPlayer changingPlayer) {
        List players = changingPlayer.field_70170_p.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.pos.func_177982_a(-5, -5, -5), this.pos.func_177982_a(6, 6, 6)));
        for (EntityPlayerMP player : players) {
            if (player == changingPlayer) continue;
            NetworkHandler.sendTo(new PacketProgrammerUpdate(te), player);
        }
    }
}

