/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemEmptyPCB;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class TileEntityUVLightBox
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.uvLightBox.button.chance.70", (Object)"gui.tab.redstoneBehaviour.uvLightBox.button.chance.80", (Object)"gui.tab.redstoneBehaviour.uvLightBox.button.chance.90", (Object)"gui.tab.redstoneBehaviour.uvLightBox.button.chance.100");
    public static final int INVENTORY_SIZE = 1;
    public static final int PCB_SLOT = 0;
    private Object light = null;
    @DescSynced
    public boolean areLightsOn;
    @GuiSynced
    public int redstoneMode;
    @DescSynced
    public boolean hasLoadedPCB;
    public final LightBoxItemHandlerInternal inventory = new LightBoxItemHandlerInternal();
    private final LightBoxItemHandlerExternal inventoryExt = new LightBoxItemHandlerExternal(this.inventory);
    public int ticksExisted;
    private boolean oldRedstoneStatus;

    public TileEntityUVLightBox() {
        super(5.0f, 7.0f, 2000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.redstoneMode = nbt.func_74762_e("redstoneMode");
        this.inventory.deserializeNBT(nbt.func_74775_l("Items"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("redstoneMode", this.redstoneMode);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            ++this.ticksExisted;
            ItemStack stack = this.getLoadedPCB();
            if (this.getPressure() >= 1.0f && stack.func_77973_b() instanceof ItemEmptyPCB && stack.func_77952_i() > 0) {
                this.addAir((int)(-2.0f * this.getSpeedUsageMultiplierFromUpgrades()));
                if (this.ticksExisted % this.ticksPerProgress(stack.func_77952_i()) == 0) {
                    if (!this.areLightsOn) {
                        this.setLightsOn(true);
                        this.updateNeighbours();
                    }
                    stack.func_77964_b(Math.max(0, stack.func_77952_i() - 1));
                }
            } else if (this.areLightsOn) {
                this.setLightsOn(false);
                this.updateNeighbours();
            }
            if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
                this.oldRedstoneStatus = !this.oldRedstoneStatus;
                this.updateNeighbours();
            }
        }
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        this.hasLoadedPCB = !this.getLoadedPCB().func_190926_b();
    }

    private int ticksPerProgress(int damage) {
        int ticks = damage > 80 ? 20 : (damage > 60 ? 40 : (damage > 40 ? 80 : (damage > 20 ? 160 : 300)));
        return Math.max(1, (int)((float)ticks / this.getSpeedMultiplierFromUpgrades()));
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    private void setLightsOn(boolean lightsOn) {
        boolean check = this.areLightsOn != lightsOn;
        this.areLightsOn = lightsOn;
        if (check) {
            this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            this.sendDescriptionPacket();
        }
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public int getLightLevel() {
        return this.areLightsOn ? Math.max(15, this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED)) + 11 : 0;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side == this.getRotation().func_176735_f();
    }

    @Override
    public String getName() {
        return Blockss.UV_LIGHT_BOX.func_149739_a();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 4) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        }
    }

    public boolean shouldEmitRedstone() {
        ItemStack stack = this.getLoadedPCB();
        if (this.redstoneMode == 0 || stack.func_77973_b() != Itemss.EMPTY_PCB) {
            return false;
        }
        switch (this.redstoneMode) {
            case 1: {
                return stack.func_77952_i() < 30;
            }
            case 2: {
                return stack.func_77952_i() < 20;
            }
            case 3: {
                return stack.func_77952_i() < 10;
            }
            case 4: {
                return stack.func_77952_i() == 0;
            }
        }
        return false;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventoryExt);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    public float getMinWorkingPressure() {
        return 1.0f;
    }

    private ItemStack getLoadedPCB() {
        return this.inventory.getStackInSlot(0);
    }

    private class LightBoxItemHandlerExternal
    implements IItemHandlerModifiable {
        private final LightBoxItemHandlerInternal wrapped;

        LightBoxItemHandlerExternal(LightBoxItemHandlerInternal wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.wrapped.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileEntityUVLightBox.this.redstoneMode != 0 && !TileEntityUVLightBox.this.shouldEmitRedstone()) {
                return ItemStack.field_190927_a;
            }
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.wrapped.setStackInSlot(slot, stack);
        }
    }

    private class LightBoxItemHandlerInternal
    extends BaseItemStackHandler {
        LightBoxItemHandlerInternal() {
            super(TileEntityUVLightBox.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemEmptyPCB;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityUVLightBox.this.hasLoadedPCB = !this.getStackInSlot(slot).func_190926_b();
        }
    }
}

