/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Arrays;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetDropItem;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryExport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryImport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidExport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidImport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetSuicide;
import me.desht.pneumaticcraft.common.util.DroneProgramBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class ProgrammedDroneUtils {
    private static EntityDrone getChargedDispenserUpgradeDrone(World world, BlockPos pos) {
        EntityDrone drone = new EntityDrone(world, null);
        NBTTagCompound tag = new NBTTagCompound();
        drone.func_70014_b(tag);
        ItemStackHandler upgrades = new ItemStackHandler(9);
        upgrades.setStackInSlot(0, new ItemStack(ItemRegistry.getInstance().getUpgrade(IItemRegistry.EnumUpgrade.DISPENSER), 64));
        upgrades.setStackInSlot(1, new ItemStack(ItemRegistry.getInstance().getUpgrade(IItemRegistry.EnumUpgrade.SPEED), 10));
        tag.func_74782_a("UpgradeInventory", (NBTBase)upgrades.serializeNBT());
        tag.func_74782_a("Inventory", (NBTBase)new NBTTagCompound());
        tag.func_74776_a("currentAir", 100000.0f);
        drone.func_70037_a(tag);
        drone.func_96094_a(I18n.func_74838_a((String)"drone.amadronDeliveryDrone"));
        drone.naturallySpawned = true;
        int startY = world.func_175645_m(pos.func_177982_a(30, 0, 0)).func_177956_o() + 27 + world.field_73012_v.nextInt(6);
        drone.func_70107_b(pos.func_177958_n() + 27 + world.field_73012_v.nextInt(6), startY, pos.func_177952_p() + world.field_73012_v.nextInt(6) - 3);
        return drone;
    }

    public static EntityCreature deliverItemsAmazonStyle(World world, BlockPos pos, ItemStack ... deliveredStacks) {
        int i;
        if (world.field_72995_K) {
            return null;
        }
        Validate.isTrue((deliveredStacks.length > 0 && deliveredStacks.length <= 65 ? 1 : 0) != 0, (String)"You can only deliver between 0 & 65 stacks at once!", (Object[])new Object[0]);
        Arrays.stream(deliveredStacks).forEach(stack -> Validate.isTrue((!stack.func_190926_b() ? 1 : 0) != 0, (String)"You can't supply an empty stack to be delivered!", (Object[])new Object[0]));
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        builder.add(new ProgWidgetInventoryExport(), ProgWidgetArea.fromPosition(pos));
        ProgWidgetArea area = ProgWidgetArea.fromPosition(pos);
        if (drone.isBlockValidPathfindBlock(pos)) {
            for (i = 0; i < 5 && drone.isBlockValidPathfindBlock(new BlockPos(area.x1, area.y1, area.z1)); ++i) {
                area.y1 = pos.func_177956_o() + i;
            }
        } else {
            area.y1 = world.func_175645_m(pos).func_177956_o() + 10;
            if (!drone.isBlockValidPathfindBlock(new BlockPos(area.x1, area.y1, area.z1))) {
                area.y1 = 260;
            }
        }
        builder.add(new ProgWidgetDropItem(), area);
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        for (i = 0; i < deliveredStacks.length; ++i) {
            drone.getInv().setStackInSlot(i, deliveredStacks[i].func_77946_l());
        }
        world.func_72838_d((Entity)drone);
        return drone;
    }

    public static EntityCreature deliverFluidAmazonStyle(World world, BlockPos pos, FluidStack deliveredFluid) {
        if (world.field_72995_K) {
            return null;
        }
        Validate.notNull((Object)deliveredFluid, (String)"Can't deliver a null FluidStack", (Object[])new Object[0]);
        Validate.isTrue((deliveredFluid.amount > 0 ? 1 : 0) != 0, (String)"Can't deliver a FluidStack with an amount of <= 0", (Object[])new Object[0]);
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        builder.add(new ProgWidgetLiquidExport(), ProgWidgetArea.fromPosition(pos));
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        drone.getTank().fill(deliveredFluid, true);
        world.func_72838_d((Entity)drone);
        return drone;
    }

    public static EntityCreature retrieveItemsAmazonStyle(World world, BlockPos pos, ItemStack ... queriedStacks) {
        if (world.field_72995_K) {
            return null;
        }
        Validate.isTrue((queriedStacks.length > 0 && queriedStacks.length <= 65 ? 1 : 0) != 0, (String)"Must retrieve between 1 & 65 itemstacks!", (Object[])new Object[0]);
        Arrays.stream(queriedStacks).forEach(stack -> Validate.isTrue((!stack.func_190926_b() ? 1 : 0) != 0, (String)"Cannot retrieve an empty stack!", (Object[])new Object[0]));
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        for (ItemStack stack2 : queriedStacks) {
            ProgWidgetInventoryImport widgetImport = new ProgWidgetInventoryImport();
            widgetImport.setUseCount(true);
            widgetImport.setCount(stack2.func_190916_E());
            ProgWidgetItemFilter filter = ProgWidgetItemFilter.withFilter(stack2);
            filter.useMetadata = true;
            filter.useNBT = true;
            builder.add(widgetImport, ProgWidgetArea.fromPosition(pos), filter);
        }
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        world.func_72838_d((Entity)drone);
        return drone;
    }

    public static EntityCreature retrieveFluidAmazonStyle(World world, BlockPos pos, FluidStack queriedFluid) {
        if (world.field_72995_K) {
            return null;
        }
        Validate.notNull((Object)queriedFluid, (String)"Can't retrieve a null FluidStack", (Object[])new Object[0]);
        Validate.isTrue((queriedFluid.amount > 0 ? 1 : 0) != 0, (String)"Can't retrieve a FluidStack with an amount of <= 0", (Object[])new Object[0]);
        EntityDrone drone = ProgrammedDroneUtils.getChargedDispenserUpgradeDrone(world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        ProgWidgetLiquidImport liquidImport = new ProgWidgetLiquidImport();
        liquidImport.setUseCount(true);
        liquidImport.setCount(queriedFluid.amount);
        builder.add(liquidImport, ProgWidgetArea.fromPosition(pos), ProgWidgetLiquidFilter.withFilter(queriedFluid.getFluid()));
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.func_180425_c()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        world.func_72838_d((Entity)drone);
        return drone;
    }
}

