/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import net.malisis.core.block.IBlockComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;

public class SubtypeComponent<T extends Enum<T>>
implements IBlockComponent {
    private Class<T> enumClass;
    private PropertyEnum<T> property;

    public SubtypeComponent(Class<T> clazz, PropertyEnum<T> property) {
        this.enumClass = clazz;
        this.property = property;
        if (((Enum[])clazz.getEnumConstants()).length > 16) {
            throw new IllegalArgumentException("Cannot save all the state derived from " + clazz.getSimpleName() + " in 4 bits metadata");
        }
    }

    public SubtypeComponent(Class<T> clazz) {
        this(clazz, PropertyEnum.func_177709_a((String)clazz.getSimpleName().toLowerCase(), clazz));
    }

    @Override
    public String getUnlocalizedName(Block block, IBlockState state) {
        return block.func_149739_a() + "." + ((IStringSerializable)((Enum)((Object)state.func_177229_b(this.getProperty())))).func_176610_l();
    }

    @Override
    public boolean getHasSubtypes(Block block, Item item) {
        return true;
    }

    public PropertyEnum<T> getProperty() {
        return this.property;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a(this.getProperty(), (Comparable)((Object)((Enum[])this.enumClass.getEnumConstants())[0]));
    }

    @Override
    public void getSubBlocks(Block block, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < ((Enum[])this.enumClass.getEnumConstants()).length; ++i) {
            list.add((Object)new ItemStack(block, 1, i));
        }
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a(this.getProperty(), (Comparable)((Object)((Enum[])this.enumClass.getEnumConstants())[meta]));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.getProperty()))).ordinal();
    }
}

