/*
 * Decompiled with CFR 0.152.
 */
package com.msvdaamen.proxy;

import com.msvdaamen.Drawbridges;
import com.msvdaamen.blocks.BasicBlock;
import com.msvdaamen.blocks.Drawbridge;
import com.msvdaamen.blocks.DrawbridgeAdvanced;
import com.msvdaamen.blocks.DrawbridgeExtended;
import com.msvdaamen.init.Config;
import com.msvdaamen.init.ModBlocks;
import com.msvdaamen.init.ModItems;
import com.msvdaamen.init.ModOredict;
import com.msvdaamen.inventory.GuiProxy;
import com.msvdaamen.network.PacketHandler;
import com.msvdaamen.tileentities.DrawbridgeAdvancedTileEntity;
import com.msvdaamen.tileentities.DrawbridgeExtendedTileEntity;
import com.msvdaamen.tileentities.DrawbridgeTileEntity;
import com.msvdaamen.world.OreGen;
import java.io.File;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy {
    public static Configuration config;

    public void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "drawbridges.cfg"));
        Config.readConfig();
        PacketHandler.registerMessages("drawbridges");
    }

    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Drawbridges.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (config.hasChanged()) {
            config.save();
        }
        if (!Config.useVanillaRecipe) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGen(), (int)0);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Drawbridge("drawbridge", CommonProxy.getRange(Config.drawbridgeRange), 10));
        GameRegistry.registerTileEntity(DrawbridgeTileEntity.class, (ResourceLocation)new ResourceLocation("drawbridges", "_drawbridge"));
        event.getRegistry().register((IForgeRegistryEntry)new DrawbridgeExtended("drawbridge_extended", CommonProxy.getRange(Config.extendedDrawbridgeRange), 10));
        GameRegistry.registerTileEntity(DrawbridgeExtendedTileEntity.class, (ResourceLocation)new ResourceLocation("drawbridges", "_drawbridge_extended"));
        event.getRegistry().register((IForgeRegistryEntry)new DrawbridgeAdvanced("drawbridge_advanced", 64, 10));
        GameRegistry.registerTileEntity(DrawbridgeAdvancedTileEntity.class, (ResourceLocation)new ResourceLocation("drawbridges", "drawbridge_advanced"));
        event.getRegistry().register((IForgeRegistryEntry)new BasicBlock("ore_copper"));
        event.getRegistry().register((IForgeRegistryEntry)new BasicBlock("ore_tin"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.drawbridge).setRegistryName(Objects.requireNonNull(ModBlocks.drawbridge.getRegistryName())));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.drawbridgeExtended).setRegistryName(Objects.requireNonNull(ModBlocks.drawbridgeExtended.getRegistryName())));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.drawbridgeAdvanced).setRegistryName(Objects.requireNonNull(ModBlocks.drawbridgeAdvanced.getRegistryName())));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.oreCopper).setRegistryName(Objects.requireNonNull(ModBlocks.oreCopper.getRegistryName())));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.oreTin).setRegistryName(Objects.requireNonNull(ModBlocks.oreTin.getRegistryName())));
        ModItems.registerItems(event);
        ModOredict.registerOredict();
    }

    private static int getRange(int range) {
        if (range == 0) {
            return 1;
        }
        if (range > 64) {
            return 64;
        }
        return range;
    }
}

