/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import appeng.api.AEApi;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.gui.GuiPackager;
import thelm.packagedauto.container.ContainerPackager;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.networking.HostHelperTilePackager;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternHelper;
import thelm.packagedauto.inventory.InventoryPackager;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileUnpackager;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.crafting.ICraftingProvider", modid="appliedenergistics2")})
public class TilePackager
extends TileBase
implements ITickable,
IGridHost,
IActionHost,
ICraftingProvider {
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static boolean drawMEEnergy = true;
    public static boolean checkDisjoint = true;
    public static boolean forceDisjoint = false;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public List<IPackagePattern> patternList = new ArrayList<IPackagePattern>();
    public IPackagePattern currentPattern;
    public boolean lockPattern = false;
    public boolean disjoint = false;
    public boolean powered = false;
    public HostHelperTilePackager hostHelper;

    public TilePackager() {
        this.setInventory(new InventoryPackager(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTilePackager(this);
        }
    }

    @Override
    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedauto.packager.name");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isInputValid()) {
                    this.energyStorage.receiveEnergy(Math.abs(this.remainingProgress), false);
                    this.finishProcess();
                    if (this.hostHelper != null && this.hostHelper.isActive() && !this.inventory.func_70301_a(9).func_190926_b()) {
                        this.hostHelper.ejectItem();
                    } else if (!this.inventory.func_70301_a(9).func_190926_b()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.field_145850_b.func_82737_E() % 8L == 0L && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                if (this.hostHelper != null && this.hostHelper.isActive()) {
                    if (!this.inventory.func_70301_a(9).func_190926_b()) {
                        this.hostHelper.ejectItem();
                    }
                    if (drawMEEnergy) {
                        this.hostHelper.chargeEnergy();
                    }
                } else if (!this.inventory.func_70301_a(9).func_190926_b()) {
                    this.ejectItem();
                }
            }
            this.energyStorage.updateIfChanged();
        }
    }

    protected static Ingredient getIngredient(ItemStack stack) {
        return stack.func_77942_o() ? new IngredientNBT(stack){} : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
    }

    public boolean isInputValid() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            return false;
        }
        List<ItemStack> input = this.inventory.stacks.subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            return false;
        }
        if (!this.lockPattern && this.disjoint) {
            return MiscUtil.removeExactSet(input, this.currentPattern.getInputs(), true);
        }
        List matchers = Lists.transform(this.currentPattern.getInputs(), TilePackager::getIngredient);
        int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
        if (matches == null) {
            return false;
        }
        for (int i = 0; i < matches.length; ++i) {
            if (input.get(i).func_190916_E() >= this.currentPattern.getInputs().get(matches[i]).func_190916_E()) continue;
            return false;
        }
        return true;
    }

    protected boolean canStart() {
        this.getPattern();
        if (this.currentPattern == null) {
            return false;
        }
        if (!this.isInputValid()) {
            return false;
        }
        ItemStack slotStack = this.inventory.func_70301_a(9);
        ItemStack outputStack = this.currentPattern.getOutput();
        return slotStack.func_190926_b() || slotStack.func_77973_b() == outputStack.func_77973_b() && slotStack.func_77952_i() == outputStack.func_77952_i() && ItemStack.areItemStackShareTagsEqual((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + 1 <= outputStack.func_77976_d();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isInputValid();
    }

    protected void getPattern() {
        if (this.currentPattern != null && this.lockPattern) {
            return;
        }
        this.lockPattern = false;
        this.currentPattern = null;
        if (this.powered) {
            return;
        }
        List<ItemStack> input = this.inventory.stacks.subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            return;
        }
        for (IPackagePattern pattern : this.patternList) {
            if (this.disjoint) {
                if (!MiscUtil.removeExactSet(input, pattern.getInputs(), true)) continue;
                this.currentPattern = pattern;
                return;
            }
            List matchers = Lists.transform(pattern.getInputs(), TilePackager::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) continue;
            this.currentPattern = pattern;
            return;
        }
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(energyUsage, false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            this.endProcess();
            return;
        }
        List<ItemStack> input = this.inventory.stacks.subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            this.endProcess();
            return;
        }
        if (!this.lockPattern && this.disjoint) {
            if (!MiscUtil.removeExactSet(input, this.currentPattern.getInputs(), true)) {
                this.endProcess();
                return;
            }
            if (this.inventory.func_70301_a(9).func_190926_b()) {
                this.inventory.func_70299_a(9, this.currentPattern.getOutput());
            } else if (this.inventory.func_70301_a(9).func_77973_b() instanceof IPackageItem) {
                this.inventory.func_70301_a(9).func_190917_f(1);
            } else {
                this.endProcess();
                return;
            }
            MiscUtil.removeExactSet(input, this.currentPattern.getInputs(), false);
        } else {
            List matchers = Lists.transform(this.currentPattern.getInputs(), TilePackager::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) {
                this.endProcess();
                return;
            }
            if (this.inventory.func_70301_a(9).func_190926_b()) {
                this.inventory.func_70299_a(9, this.currentPattern.getOutput());
            } else if (this.inventory.func_70301_a(9).func_77973_b() instanceof IPackageItem) {
                this.inventory.func_70301_a(9).func_190917_f(1);
            } else {
                this.endProcess();
                return;
            }
            for (int i = 0; i < matches.length; ++i) {
                input.get(i).func_190918_g(this.currentPattern.getInputs().get(matches[i]).func_190916_E());
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.inventory.func_70301_a(i).func_190926_b()) continue;
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    protected void startProcess() {
        this.remainingProgress = energyReq;
        this.func_70296_d();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.lockPattern = false;
        this.func_70296_d();
    }

    protected void ejectItem() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(te instanceof TileUnpackager)) continue;
            TileUnpackager tile = (TileUnpackager)te;
            ItemStack stack = this.inventory.func_70301_a(9);
            if (stack.func_190926_b()) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stackRem = itemHandler.insertItem(slot, stack, false);
                if (stackRem.func_190916_E() < stack.func_190916_E()) {
                    stack = stackRem;
                }
                if (stack.func_190926_b()) break;
            }
            this.inventory.func_70299_a(9, stack);
        }
    }

    protected void chargeEnergy() {
        int prevStored = this.energyStorage.getEnergyStored();
        ItemStack energyStack = this.inventory.func_70301_a(11);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(11, ItemStack.field_190927_a);
            }
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            this.powered = !this.powered;
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void setPlacer(EntityPlayer placer) {
        this.placerID = AEApi.instance().registries().players().getID(placer);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.isBusy() && patternDetails instanceof PackageCraftingPatternHelper) {
            PackageCraftingPatternHelper pattern = (PackageCraftingPatternHelper)patternDetails;
            ItemStack slotStack = this.inventory.func_70301_a(9);
            ItemStack outputStack = pattern.pattern.getOutput();
            if (slotStack.func_190926_b() || slotStack.func_77973_b() == outputStack.func_77973_b() && slotStack.func_77952_i() == outputStack.func_77952_i() && ItemStack.areItemStackShareTagsEqual((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + 1 <= outputStack.func_77976_d()) {
                this.currentPattern = pattern.pattern;
                this.lockPattern = true;
                for (int i = 0; i < table.func_70302_i_() && i < 9; ++i) {
                    this.inventory.func_70299_a(i, table.func_70301_a(i).func_77946_l());
                }
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isBusy() {
        return this.isWorking || !this.inventory.stacks.subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        ItemStack listStack = this.inventory.func_70301_a(10);
        for (IPackagePattern pattern : this.patternList) {
            craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)new PackageCraftingPatternHelper(listStack, pattern));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        IRecipeInfo recipe;
        super.func_145839_a(nbt);
        this.lockPattern = false;
        this.currentPattern = null;
        if (nbt.func_74764_b("Pattern") && (recipe = MiscUtil.readRecipeFromNBT(tag = nbt.func_74775_l("Pattern"))) != null) {
            List<IPackagePattern> patterns = recipe.getPatterns();
            byte index = tag.func_74771_c("Index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = patterns.get(index);
                this.lockPattern = true;
            }
        }
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.lockPattern) {
            NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), this.currentPattern.getRecipeInfo());
            tag.func_74774_a("Index", (byte)this.currentPattern.getIndex());
            nbt.func_74782_a("Pattern", (NBTBase)tag);
        }
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.remainingProgress = nbt.func_74762_e("Progress");
        this.powered = nbt.func_74767_n("Powered");
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        nbt.func_74768_a("Progress", this.remainingProgress);
        nbt.func_74757_a("Powered", this.powered);
        return nbt;
    }

    public void func_70296_d() {
        if (this.isWorking && !this.isInputValid()) {
            this.endProcess();
        }
        super.func_70296_d();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiPackager(new ContainerPackager(player.field_71071_by, this));
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerPackager(player.field_71071_by, this);
    }
}

