/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.util;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class InventoryUtil {
    private static final Random RANDOM = new Random();

    public static void dropInventoryItems(World worldIn, double x, double y, double z, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            InventoryUtil.spawnItemStack(worldIn, x, y, z, itemstack);
        }
    }

    private static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        float offsetX = RANDOM.nextFloat() * 0.25f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.25f + 0.1f;
        while (!stack.func_190926_b()) {
            EntityItem entity = new EntityItem(worldIn, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, stack.func_77979_a(RANDOM.nextInt(21) + 10));
            entity.field_70159_w = RANDOM.nextGaussian() * (double)0.05f;
            entity.field_70181_x = RANDOM.nextGaussian() * (double)0.05f + (double)0.2f;
            entity.field_70179_y = RANDOM.nextGaussian() * (double)0.05f;
            worldIn.func_72838_d((Entity)entity);
        }
    }

    public static int getItemAmount(EntityPlayer player, Item item) {
        int amount = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            amount += stack.func_190916_E();
        }
        return amount;
    }

    public static boolean hasItemAndAmount(EntityPlayer player, Item item, int amount) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item) continue;
            count += stack.func_190916_E();
        }
        return amount <= count;
    }

    public static boolean removeItemWithAmount(EntityPlayer player, Item item, int amount) {
        if (InventoryUtil.hasItemAndAmount(player, item, amount)) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != item) continue;
                if (amount - stack.func_190916_E() < 0) {
                    stack.func_190918_g(amount);
                    return true;
                }
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                if ((amount -= stack.func_190916_E()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getItemStackAmount(EntityPlayer player, ItemStack find) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !InventoryUtil.areItemStacksEqualIgnoreCount(stack, find)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean hasItemStack(EntityPlayer player, ItemStack find) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !InventoryUtil.areItemStacksEqualIgnoreCount(stack, find)) continue;
            count += stack.func_190916_E();
        }
        return find.func_190916_E() <= count;
    }

    public static boolean removeItemStack(EntityPlayer player, ItemStack find) {
        int amount = find.func_190916_E();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !InventoryUtil.areItemStacksEqualIgnoreCount(stack, find)) continue;
            if (amount - stack.func_190916_E() < 0) {
                stack.func_190918_g(amount);
                return true;
            }
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            if ((amount -= stack.func_190916_E()) != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean areItemStacksEqualIgnoreCount(ItemStack source, ItemStack target) {
        if (source.func_77973_b() != target.func_77973_b()) {
            return false;
        }
        if (source.func_77952_i() != target.func_77952_i()) {
            return false;
        }
        if (source.func_77978_p() == null && target.func_77978_p() != null) {
            return false;
        }
        return (source.func_77978_p() == null || source.func_77978_p().equals((Object)target.func_77978_p())) && source.areCapsCompatible(target);
    }
}

