/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.block;

import com.mrcrayfish.device.tileentity.TileEntityDevice;
import com.mrcrayfish.device.util.IColored;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockDevice
extends BlockHorizontal {
    protected BlockDevice(Material materialIn) {
        super(materialIn);
        this.func_149711_c(0.5f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDevice) {
            TileEntityDevice tileEntityDevice = (TileEntityDevice)tileEntity;
            if (stack.func_82837_s()) {
                tileEntityDevice.setCustomName(stack.func_82833_r());
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityDevice) {
            TileEntityDevice device = (TileEntityDevice)tileEntity;
            NBTTagCompound tileEntityTag = new NBTTagCompound();
            tileEntity.func_189515_b(tileEntityTag);
            tileEntityTag.func_82580_o("x");
            tileEntityTag.func_82580_o("y");
            tileEntityTag.func_82580_o("z");
            tileEntityTag.func_82580_o("id");
            tileEntityTag.func_82580_o("color");
            this.removeTagsForDrop(tileEntityTag);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("BlockEntityTag", (NBTBase)tileEntityTag);
            ItemStack drop = tileEntity instanceof IColored ? new ItemStack(Item.func_150898_a((Block)this), 1, ((IColored)tileEntity).getColor().func_176765_a()) : new ItemStack(Item.func_150898_a((Block)this));
            drop.func_77982_d(compound);
            if (device.hasCustomName()) {
                drop.func_151001_c(device.getCustomName());
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
            return world.func_175698_g(pos);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    protected void removeTagsForDrop(NBTTagCompound tileEntityTag) {
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public static abstract class Colored
    extends BlockDevice {
        protected Colored(Material materialIn) {
            super(materialIn);
        }

        @Override
        public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IColored) {
                drops.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, ((IColored)tileEntity).getColor().func_176765_a()));
            }
        }

        public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IColored) {
                return new ItemStack(Item.func_150898_a((Block)this), 1, ((IColored)tileEntity).getColor().func_176765_a());
            }
            return super.getPickBlock(state, target, world, pos, player);
        }

        @Override
        public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
            super.func_180633_a(worldIn, pos, state, placer, stack);
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof IColored) {
                IColored colored = (IColored)tileEntity;
                colored.setColor(EnumDyeColor.func_176764_b((int)stack.func_77960_j()));
            }
        }

        public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof IColored) {
                IColored colored = (IColored)tileEntity;
                state = state.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)colored.getColor());
            }
            return state;
        }

        @Override
        public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
            TileEntity tileEntity;
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tileEntity = world.func_175625_s(pos)) instanceof IColored) {
                TileEntityDevice device;
                IColored colored = (IColored)tileEntity;
                NBTTagCompound tileEntityTag = new NBTTagCompound();
                tileEntity.func_189515_b(tileEntityTag);
                tileEntityTag.func_82580_o("x");
                tileEntityTag.func_82580_o("y");
                tileEntityTag.func_82580_o("z");
                tileEntityTag.func_82580_o("id");
                tileEntityTag.func_82580_o("color");
                this.removeTagsForDrop(tileEntityTag);
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("BlockEntityTag", (NBTBase)tileEntityTag);
                ItemStack drop = new ItemStack(Item.func_150898_a((Block)this), 1, colored.getColor().func_176765_a());
                drop.func_77982_d(compound);
                if (tileEntity instanceof TileEntityDevice && (device = (TileEntityDevice)tileEntity).hasCustomName()) {
                    drop.func_151001_c(device.getCustomName());
                }
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
                return world.func_175698_g(pos);
            }
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }

        public int func_176201_c(IBlockState state) {
            return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        }

        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, BlockColored.field_176581_a});
        }
    }
}

