/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.auction;

import com.mrcrayfish.device.programs.auction.object.AuctionItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AuctionManager {
    public static final AuctionManager INSTANCE = new AuctionManager();
    private List<AuctionItem> items = new ArrayList<AuctionItem>();

    private AuctionManager() {
    }

    public void addItem(AuctionItem item) {
        if (!this.containsItem(item.getId())) {
            this.items.add(item);
        }
    }

    public boolean containsItem(UUID id) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public AuctionItem getItem(UUID uuid) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(uuid)) continue;
            return item;
        }
        return null;
    }

    public void removeItem(UUID uuid) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(uuid)) continue;
            this.items.remove(item);
            return;
        }
    }

    public List<AuctionItem> getItems() {
        return this.items;
    }

    public void tick() {
        for (AuctionItem item : this.items) {
            item.decrementTime();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        this.items.stream().filter(i -> i.isValid()).forEach(i -> {
            NBTTagCompound itemTag = new NBTTagCompound();
            i.writeToNBT(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        });
        tag.func_74782_a("auctionItems", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.items.clear();
        NBTTagList tagList = (NBTTagList)tag.func_74781_a("auctionItems");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            AuctionItem item = AuctionItem.readFromNBT(itemTag);
            this.items.add(item);
        }
    }

    public List<AuctionItem> getItemsForSeller(UUID seller) {
        return this.items.stream().filter(i -> i.getSellerId().equals(seller)).collect(Collectors.toList());
    }
}

