/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.gitweb.component.container;

import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.programs.gitweb.component.container.ContainerBox;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class BrewingBox
extends ContainerBox {
    private static final int[] BUBBLELENGTHS = new int[]{29, 24, 20, 16, 11, 6, 0};
    public static final int HEIGHT = 73;
    private int brewTimer;

    public BrewingBox(ItemStack fuel, ItemStack input, ItemStack[] output) {
        super(0, 0, 0, 136, 73, new ItemStack(Items.field_151067_bt), "Brewing Stand");
        this.slots.add(new ContainerBox.Slot(this, 14, 8, fuel));
        this.slots.add(new ContainerBox.Slot(this, 75, 8, input));
        this.setOutput(output);
    }

    private void setOutput(ItemStack[] output) {
        if (output.length > 0) {
            this.slots.add(new ContainerBox.Slot(this, 52, 42, output[0]));
        }
        if (output.length > 1) {
            this.slots.add(new ContainerBox.Slot(this, 75, 49, output[1]));
        }
        if (output.length > 2) {
            this.slots.add(new ContainerBox.Slot(this, 98, 42, output[1]));
        }
    }

    @Override
    protected void handleTick() {
        if (--this.brewTimer < 0) {
            this.brewTimer = 400;
        }
    }

    @Override
    protected void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        super.render(laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        mc.func_110434_K().func_110577_a(CONTAINER_BOXES_TEXTURE);
        this.func_73729_b(x + 56, y + 47, 152, 252, 18, 4);
        if (this.brewTimer > 0 && this.slots.size() > 1 && !((ContainerBox.Slot)this.slots.get(1)).getStack().func_190926_b()) {
            int scaledPercent = (int)(28.0f * (1.0f - (float)this.brewTimer / 400.0f));
            if (scaledPercent > 0) {
                this.func_73729_b(x + 93, y + 19, 152, 223, 9, scaledPercent);
            }
            if ((scaledPercent = BUBBLELENGTHS[this.brewTimer / 2 % 7]) > 0) {
                this.func_73729_b(x + 59, y + 16 + 29 - scaledPercent, 161, 251 - scaledPercent, 12, scaledPercent);
            }
        }
    }
}

