/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.ScrollableLayout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.component.Spinner;
import com.mrcrayfish.device.api.utils.OnlineRequest;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.object.TrayItem;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.programs.system.component.AppGrid;
import com.mrcrayfish.device.programs.system.layout.LayoutAppPage;
import com.mrcrayfish.device.programs.system.layout.LayoutSearchApps;
import com.mrcrayfish.device.programs.system.object.AppEntry;
import com.mrcrayfish.device.programs.system.object.RemoteEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class ApplicationAppStore
extends SystemApplication {
    public static final String CERTIFIED_APPS_URL = "https://raw.githubusercontent.com/MrCrayfish/DeviceMod-CertifiedApps/master";
    public static final int LAYOUT_WIDTH = 250;
    public static final int LAYOUT_HEIGHT = 150;
    private Layout layoutMain;
    public List<AppEntry> certifiedApps = new ArrayList<AppEntry>();

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.layoutMain = new Layout(250, 150);
        ScrollableLayout homePageLayout = new ScrollableLayout(0, 0, 250, 368, 150);
        homePageLayout.setScrollSpeed(10);
        homePageLayout.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getBackgroundColor());
            int offset = 60;
            Gui.func_73734_a((int)x, (int)(y + offset), (int)(x + 250), (int)(y + offset + 1), (int)color.brighter().getRGB());
            Gui.func_73734_a((int)x, (int)(y + offset + 1), (int)(x + 250), (int)(y + offset + 19), (int)color.getRGB());
            Gui.func_73734_a((int)x, (int)(y + offset + 19), (int)(x + 250), (int)(y + offset + 20), (int)color.darker().getRGB());
            offset = 172;
            Gui.func_73734_a((int)x, (int)(y + offset), (int)(x + 250), (int)(y + offset + 1), (int)color.brighter().getRGB());
            Gui.func_73734_a((int)x, (int)(y + offset + 1), (int)(x + 250), (int)(y + offset + 19), (int)color.getRGB());
            Gui.func_73734_a((int)x, (int)(y + offset + 19), (int)(x + 250), (int)(y + offset + 20), (int)color.darker().getRGB());
        });
        Image imageBanner = new Image(0, 0, 250, 60);
        imageBanner.setImage(new ResourceLocation("cdm", "textures/gui/app_market_background.png"));
        imageBanner.setDrawFull(true);
        homePageLayout.addComponent(imageBanner);
        Button btnSearch = new Button(5, 5, Icons.SEARCH);
        btnSearch.setToolTip("Search", "Find a specific application");
        btnSearch.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(new LayoutSearchApps(this, this.getCurrentLayout()));
            }
        });
        homePageLayout.addComponent(btnSearch);
        Button btnManageApps = new Button(23, 5, Icons.HAMMER);
        btnManageApps.setToolTip("Manage Apps", "Manage your installed applications");
        homePageLayout.addComponent(btnManageApps);
        Image image = new Image(5, 33, 20, 20, Icons.SHOP);
        homePageLayout.addComponent(image);
        Label labelBanner = new Label("App Market", 32, 35);
        labelBanner.setScale(2.0);
        homePageLayout.addComponent(labelBanner);
        Label labelCertified = new Label(TextFormatting.WHITE + TextFormatting.BOLD.toString() + "Certified Apps", 10, 66);
        homePageLayout.addComponent(labelCertified);
        Label labelCertifiedDesc = new Label(TextFormatting.GRAY + "Verified by MrCrayfish", 240, 66);
        labelCertifiedDesc.setAlignment(1);
        labelCertifiedDesc.setScale(1.0);
        labelCertifiedDesc.setShadow(false);
        homePageLayout.addComponent(labelCertifiedDesc);
        Spinner spinner = new Spinner(119, 120);
        homePageLayout.addComponent(spinner);
        OnlineRequest.getInstance().make("https://raw.githubusercontent.com/MrCrayfish/DeviceMod-CertifiedApps/master/certified_apps.json", (success, response) -> {
            this.certifiedApps.clear();
            spinner.setVisible(false);
            if (success) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    AppGrid grid = new AppGrid(0, 81, 3, 1, this);
                    this.certifiedApps.addAll(this.parseJson(response));
                    this.shuffleAndShrink(this.certifiedApps, 3).forEach(grid::addEntry);
                    homePageLayout.addComponent(grid);
                    grid.reloadIcons();
                });
            }
        });
        Label labelOther = new Label(TextFormatting.WHITE + TextFormatting.BOLD.toString() + "Other Apps", 10, 178);
        homePageLayout.addComponent(labelOther);
        Label labelOtherDesc = new Label(TextFormatting.GRAY + "Community Created", 240, 178);
        labelOtherDesc.setAlignment(1);
        labelOtherDesc.setScale(1.0);
        labelOtherDesc.setShadow(false);
        homePageLayout.addComponent(labelOtherDesc);
        AppGrid other = new AppGrid(0, 192, 3, 2, this);
        this.shuffleAndShrink(ApplicationManager.getAvailableApplications(), 6).forEach(other::addEntry);
        homePageLayout.addComponent(other);
        this.layoutMain.addComponent(homePageLayout);
        this.setCurrentLayout(this.layoutMain);
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }

    public List<RemoteEntry> parseJson(String json) {
        ArrayList<RemoteEntry> entries = new ArrayList<RemoteEntry>();
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(json).getAsJsonArray();
        Gson gson = new Gson();
        array.forEach(element -> entries.add((RemoteEntry)gson.fromJson(element, new TypeToken<RemoteEntry>(){}.getType())));
        return entries;
    }

    public void openApplication(AppEntry entry) {
        LayoutAppPage layout = new LayoutAppPage(this.getLaptop(), entry, this);
        this.setCurrentLayout(layout);
        Button btnPrevious = new Button(2, 2, Icons.ARROW_LEFT);
        btnPrevious.setClickListener((mouseX1, mouseY1, mouseButton1) -> this.setCurrentLayout(this.layoutMain));
        layout.addComponent(btnPrevious);
    }

    private <T> List<T> shuffleAndShrink(List<T> list, int newSize) {
        Collections.shuffle(list);
        return list.subList(0, Math.min(list.size(), newSize));
    }

    public static class StoreTrayItem
    extends TrayItem {
        public StoreTrayItem() {
            super(Icons.SHOP);
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication("cdm:app_store");
            if (info != null) {
                Laptop.getSystem().openApplication(info);
            }
        }
    }
}

