/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system;

import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.api.app.component.TextField;
import com.mrcrayfish.device.api.task.Callback;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.api.utils.BankUtil;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.programs.system.task.TaskDeposit;
import com.mrcrayfish.device.programs.system.task.TaskWithdraw;
import com.mrcrayfish.device.util.InventoryUtil;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class ApplicationBank
extends SystemApplication {
    private static final ItemStack EMERALD = new ItemStack(Items.field_151166_bC);
    private static final ResourceLocation BANK_ASSETS = new ResourceLocation("cdm:textures/gui/bank.png");
    private static final ResourceLocation villagerTextures = new ResourceLocation("textures/entity/villager/villager.png");
    private static final ModelVillager villagerModel = new ModelVillager(0.0f);
    private Layout layoutStart;
    private Label labelTeller;
    private Text textWelcome;
    private Button btnDepositWithdraw;
    private Button btnTransfer;
    private Layout layoutMain;
    private Label labelBalance;
    private Label labelAmount;
    private TextField amountField;
    private Button btnOne;
    private Button btnTwo;
    private Button btnThree;
    private Button btnFour;
    private Button btnFive;
    private Button btnSix;
    private Button btnSeven;
    private Button btnEight;
    private Button btnNine;
    private Button btnZero;
    private Button btnClear;
    private Button buttonDeposit;
    private Button buttonWithdraw;
    private Label labelEmeraldAmount;
    private Label labelInventory;
    private int emeraldAmount;
    private int rotation;

    @Override
    public void onTick() {
        super.onTick();
        ++this.rotation;
        if (this.rotation >= 100) {
            this.rotation = 0;
        }
    }

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.layoutStart = new Layout();
        this.layoutStart.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179109_b((float)(x + 25), (float)(y + 33), (float)15.0f);
            GlStateManager.func_179152_a((float)-2.5f, (float)-2.5f, (float)-2.5f);
            GlStateManager.func_179114_b((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float scaleX = (float)(mouseX - x - 25) / (float)width;
            float scaleY = (float)(mouseY - y - 20) / (float)height;
            mc.func_110434_K().func_110577_a(villagerTextures);
            villagerModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, -70.0f * scaleX + 20.0f, 30.0f * scaleY, 1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
            mc.func_110434_K().func_110577_a(BANK_ASSETS);
            RenderUtil.drawRectWithTexture(x + 46, y + 19, 0.0f, 0.0f, 146, 52, 146.0f, 52.0f);
        });
        this.labelTeller = new Label(TextFormatting.YELLOW + "Casey The Teller", 60, 7);
        this.layoutStart.addComponent(this.labelTeller);
        this.textWelcome = new Text(TextFormatting.BLACK + "Hello " + Minecraft.func_71410_x().field_71439_g.func_70005_c_() + ", welcome to The Emerald Bank! How can I help you?", 62, 25, 125);
        this.layoutStart.addComponent(this.textWelcome);
        this.btnDepositWithdraw = new Button(54, 74, "View Account");
        this.btnDepositWithdraw.setSize(76, 20);
        this.btnDepositWithdraw.setToolTip("View Account", "Shows your balance");
        this.layoutStart.addComponent(this.btnDepositWithdraw);
        this.btnTransfer = new Button(133, 74, "Transfer");
        this.btnTransfer.setSize(58, 20);
        this.btnTransfer.setToolTip("Transfer", "Withdraw and deposit emeralds");
        this.btnTransfer.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(this.layoutMain);
            }
        });
        this.layoutStart.addComponent(this.btnTransfer);
        this.setCurrentLayout(this.layoutStart);
        this.layoutMain = new Layout(120, 143){

            @Override
            public void handleTick() {
                super.handleTick();
                int amount = InventoryUtil.getItemAmount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Items.field_151166_bC);
                ApplicationBank.this.labelEmeraldAmount.setText("x " + Integer.toString(amount));
            }
        };
        this.layoutMain.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 40), (int)Color.GRAY.getRGB());
            Gui.func_73734_a((int)x, (int)(y + 39), (int)(x + width), (int)(y + 40), (int)Color.DARK_GRAY.getRGB());
            Gui.func_73734_a((int)(x + 62), (int)(y + 103), (int)(x + 115), (int)(y + 138), (int)Color.BLACK.getRGB());
            Gui.func_73734_a((int)(x + 63), (int)(y + 104), (int)(x + 114), (int)(y + 113), (int)Color.DARK_GRAY.getRGB());
            Gui.func_73734_a((int)(x + 63), (int)(y + 114), (int)(x + 114), (int)(y + 137), (int)Color.GRAY.getRGB());
            RenderUtil.renderItem(x + 65, y + 118, EMERALD, false);
        });
        this.labelBalance = new Label("Balance", 60, 5);
        this.labelBalance.setAlignment(2);
        this.labelBalance.setShadow(false);
        this.layoutMain.addComponent(this.labelBalance);
        this.labelAmount = new Label("Loading balance...", 60, 18);
        this.labelAmount.setAlignment(2);
        this.labelAmount.setScale(2.0);
        this.layoutMain.addComponent(this.labelAmount);
        this.amountField = new TextField(5, 45, 110);
        this.amountField.setText("0");
        this.amountField.setEditable(false);
        this.layoutMain.addComponent(this.amountField);
        for (int i = 0; i < 9; ++i) {
            int posX = 5 + i % 3 * 19;
            int posY = 65 + i / 3 * 19;
            Button button = new Button(posX, posY, Integer.toString(i + 1));
            button.setSize(16, 16);
            this.addNumberClickListener(button, this.amountField, i + 1);
            this.layoutMain.addComponent(button);
        }
        this.btnZero = new Button(5, 122, "0");
        this.btnZero.setSize(16, 16);
        this.addNumberClickListener(this.btnZero, this.amountField, 0);
        this.layoutMain.addComponent(this.btnZero);
        this.btnClear = new Button(24, 122, "Clr");
        this.btnClear.setSize(35, 16);
        this.btnClear.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.amountField.setText("0");
            }
        });
        this.layoutMain.addComponent(this.btnClear);
        this.buttonDeposit = new Button(62, 65, "Deposit");
        this.buttonDeposit.setSize(53, 16);
        this.buttonDeposit.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.amountField.getText().equals("0")) {
                    return;
                }
                try {
                    int amount = Integer.parseInt(this.amountField.getText());
                    this.deposit(amount, (nbt, success) -> {
                        if (success) {
                            int balance = nbt.func_74762_e("balance");
                            this.labelAmount.setText("$" + balance);
                            this.amountField.setText("0");
                        }
                    });
                }
                catch (NumberFormatException e) {
                    this.amountField.setText("0");
                    this.openDialog(new Dialog.Message("Invalid amount. The maximum that you can deposit is 2147483647"));
                }
            }
        });
        this.layoutMain.addComponent(this.buttonDeposit);
        this.buttonWithdraw = new Button(62, 84, "Withdraw");
        this.buttonWithdraw.setSize(53, 16);
        this.buttonWithdraw.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.amountField.getText().equals("0")) {
                    return;
                }
                try {
                    int amount = Integer.parseInt(this.amountField.getText());
                    this.withdraw(amount, (nbt, success) -> {
                        if (success) {
                            int balance = nbt.func_74762_e("balance");
                            this.labelAmount.setText("$" + balance);
                            this.amountField.setText("0");
                        }
                    });
                }
                catch (NumberFormatException e) {
                    this.amountField.setText("0");
                    this.openDialog(new Dialog.Message("Invalid amount. The maximum that you can withdraw is 2147483647"));
                }
            }
        });
        this.layoutMain.addComponent(this.buttonWithdraw);
        this.labelEmeraldAmount = new Label("x 0", 83, 123);
        this.layoutMain.addComponent(this.labelEmeraldAmount);
        this.labelInventory = new Label("Wallet", 74, 105);
        this.labelInventory.setShadow(false);
        this.layoutMain.addComponent(this.labelInventory);
        BankUtil.getBalance((nbt, success) -> {
            if (success) {
                int balance = nbt.func_74762_e("balance");
                this.labelAmount.setText("$" + balance);
            }
        });
    }

    public void addNumberClickListener(Button btn, TextField field, int number) {
        btn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (!(mouseButton != 0 || field.getText().equals("0") && number == 0)) {
                if (field.getText().equals("0")) {
                    field.clear();
                }
                field.writeText(Integer.toString(number));
            }
        });
    }

    private void deposit(int amount, Callback<NBTTagCompound> callback) {
        TaskManager.sendTask(new TaskDeposit(amount).setCallback(callback));
    }

    private void withdraw(int amount, Callback<NBTTagCompound> callback) {
        TaskManager.sendTask(new TaskWithdraw(amount).setCallback(callback));
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }
}

